/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.plot;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.Area2D;
import com.equestricraft.core.plot.PlotCoordinateUtility;
import com.equestricraft.core.plot.PlotRepository;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.plot.PlotGridWorldPurgeSession;
import java.io.File;
import java.util.List;
import java.util.Objects;

public class PlotGridWorldPurgeSessionImpl
implements PlotGridWorldPurgeSession {
    @Service
    private PlotRepository plotRepository;
    private static final Log log = Log.getLogger(PlotGridWorldPurgeSessionImpl.class.getName());

    @Override
    public void purgePlotWorld() {
        log.info("Beginning purge of unused plot chunks");
        File regionDirectory = new File("world/dimensions/equestricraft/ecplotgrid/region");
        Objects.requireNonNull(regionDirectory, "Plot world region directory does not exist");
        File[] files = regionDirectory.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("No files in the region directory");
        }
        List<Area2D> usedAreas = this.plotRepository.findAllGridPlots().stream().flatMap(p -> p.getAreas().stream()).map(PlotCoordinateUtility::getAreaOfPlotCoordinate).toList();
        int deletedFilesCount = 0;
        for (File file : files) {
            if (!file.getName().endsWith(".mca") || this.isFileInUse(file, usedAreas)) continue;
            boolean deleted = file.delete();
            if (deleted) {
                ++deletedFilesCount;
                continue;
            }
            log.warn("Chunk file {} could not be deleted", (Object)file.getName());
        }
        log.info("Deleted {} unused plot world chunk files", (Object)deletedFilesCount);
    }

    private boolean isFileInUse(File file, List<Area2D> usedAreas) {
        Area2D area = this.getAreaRepresentedByChunkFile(file);
        return usedAreas.stream().anyMatch(area::overlapsWith);
    }

    private Area2D getAreaRepresentedByChunkFile(File file) {
        String name = file.getName();
        String[] parts = name.split("\\.");
        int x = Integer.parseInt(parts[1]);
        int z = Integer.parseInt(parts[2]);
        int minX = x * 512;
        int minZ = z * 512;
        int maxX = minX + 512;
        int maxZ = minZ + 512;
        return new Area2D(minX, maxX, minZ, maxZ);
    }
}

