/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.plot;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.Point2D;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.core.plot.Plot;
import com.equestricraft.core.plot.PlotInfo;
import com.equestricraft.core.plot.PlotPermissionChecker;
import com.equestricraft.core.plot.PlotSession;
import com.equestricraft.core.plot.PlotType;
import com.equestricraft.mod.movement.PlayerMoveEvent;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.plot.PlotEnterEvent;
import com.equestricraft.mod.plot.PlotExitEvent;
import com.equestricraft.mod.plot.PlotService;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class PlotListener {
    @Service
    private static PlotService plotService;
    @Service
    private static PlotSession plotSession;
    private static final OnlinePlayerCache onlinePlayerCache;

    @SubscribeEvent
    public static void onMove(PlayerMoveEvent event) {
        OnlinePlayer player = event.getPlayer();
        Optional<PlotType> plotType = PlotType.getPlotTypeForLevel(player.getECLevel());
        if (plotType.isEmpty()) {
            plotService.sendMinimapUpdate(player);
            return;
        }
        Point2D point = new Point2D((int)Math.floor(event.getNextLocation().x()), (int)Math.floor(event.getNextLocation().z()));
        Optional<Plot> plotAtCurrentPoint = plotSession.getPlotAtPoint(plotType.get(), point);
        Optional<Plot> currentPlot = player.getPlots().getCurrentPlot();
        if (plotAtCurrentPoint.isPresent() && currentPlot.isPresent()) {
            Plot previousPlot;
            Plot nextPlot = plotAtCurrentPoint.get();
            if (!nextPlot.equals(previousPlot = currentPlot.get())) {
                PlotListener.processPlotExit(player, previousPlot);
                boolean cancelled = PlotListener.processPlotEnter(player, nextPlot);
                if (cancelled) {
                    event.setCanceled(true);
                }
            }
        } else if (plotAtCurrentPoint.isPresent()) {
            Plot nextPlot = plotAtCurrentPoint.get();
            boolean cancelled = PlotListener.processPlotEnter(player, nextPlot);
            if (cancelled) {
                event.setCanceled(true);
            }
        } else if (currentPlot.isPresent()) {
            Plot previousPlot = currentPlot.get();
            PlotListener.processPlotExit(player, previousPlot);
        }
        plotService.sendMinimapUpdate(player);
    }

    private static boolean processPlotEnter(OnlinePlayer player, Plot plot) {
        PlotInfo info2 = plotSession.createInfoForPlot(plot);
        PlotEnterEvent event = new PlotEnterEvent(player, plot, info2);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            player.sendTitle(I18n.getLabel("plot.no-entry.title"), I18n.getLabel("plot.no-entry.subtitle", info2.ownersDisplay()));
            return true;
        }
        player.getPlots().setCurrentPlot(plot);
        return false;
    }

    private static void processPlotExit(OnlinePlayer player, Plot plot) {
        PlotInfo info2 = plotSession.createInfoForPlot(plot);
        PlotExitEvent event = new PlotExitEvent(player, info2);
        MinecraftForge.EVENT_BUS.post((Event)event);
        player.getPlots().setCurrentPlot(null);
    }

    @SubscribeEvent
    public static void checkBlockBreak(PlayerInteractEvent.LeftClickBlock event) {
        OnlinePlayer player = onlinePlayerCache.requirePlayer(event.getPlayer().m_142081_()).require(OnlinePlayer.class);
        Optional<PlotType> plotType = PlotType.getPlotTypeForLevel(player.getECLevel());
        if (plotType.isEmpty()) {
            return;
        }
        BlockPos pos = event.getPos();
        Point2D point = new Point2D(pos.m_123341_(), pos.m_123343_());
        boolean shouldBlock = plotService.shouldBlockInteraction(player, plotType.get(), point);
        if (shouldBlock) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void checkBlockPlace(PlayerInteractEvent.RightClickBlock event) {
        OnlinePlayer player = onlinePlayerCache.requirePlayer(event.getPlayer().m_142081_()).require(OnlinePlayer.class);
        Optional<PlotType> plotType = PlotType.getPlotTypeForLevel(player.getECLevel());
        if (plotType.isEmpty()) {
            return;
        }
        BlockPos pos = event.getPos().m_142300_(event.getHitVec().m_82434_());
        Point2D point = new Point2D(pos.m_123341_(), pos.m_123343_());
        boolean shouldBlock = plotService.shouldBlockInteraction(player, plotType.get(), point);
        if (shouldBlock) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void checkAccess(PlotEnterEvent event) {
        boolean shouldBlock;
        if (event.getPlayer().getPermission().hasPermission("equestricraft.plot.access-any")) {
            return;
        }
        boolean bl = shouldBlock = !PlotPermissionChecker.hasBasicAccess(event.getPlayer(), event.getPlot());
        if (shouldBlock) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void showEnterTitle(PlotEnterEvent event) {
        PlotInfo plot = event.getPlotInfo();
        OnlinePlayer player = event.getPlayer();
        player.sendTitle(I18n.getLabel("plot.entering.title", plot.name()), I18n.getLabel("plot.entering.subtitle", plot.ownersDisplay()));
    }

    @SubscribeEvent
    public static void showExitTitle(PlotExitEvent event) {
        PlotInfo plot = event.getPlot();
        OnlinePlayer player = event.getPlayer();
        player.sendTitle(I18n.getLabel("plot.leaving.title", plot.name()), I18n.getLabel("plot.leaving.subtitle", plot.ownersDisplay()));
    }

    @SubscribeEvent
    public static void showPlotNameOnLocationBar(PlotEnterEvent event) {
        OnlinePlayer player = event.getPlayer();
        Plot plot = event.getPlot();
        player.getDisplay().getLocation().setText(plot.getName());
    }

    @SubscribeEvent
    public static void removePlotNameFromLocationBar(PlotExitEvent event) {
        OnlinePlayer player = event.getPlayer();
        player.getDisplay().getLocation().clearText();
    }

    private PlotListener() {
    }

    static {
        onlinePlayerCache = OnlinePlayerCache.getInstance();
    }
}

