/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.plot;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.ECLevel;
import com.equestricraft.common.Range;
import com.equestricraft.common.coordinate.Area2D;
import com.equestricraft.common.coordinate.AreaUtility;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.common.coordinate.Point2D;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.common.util.StringUtils;
import com.equestricraft.core.blockedphrase.BlockedPhraseException;
import com.equestricraft.core.blockedphrase.BlockedPhraseService;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.namegenerator.NameGeneratorSession;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.core.player.settings.PlayerSettingsSession;
import com.equestricraft.core.plot.GridPlot;
import com.equestricraft.core.plot.Plot;
import com.equestricraft.core.plot.PlotAreaSession;
import com.equestricraft.core.plot.PlotCoordinate;
import com.equestricraft.core.plot.PlotException;
import com.equestricraft.core.plot.PlotInfo;
import com.equestricraft.core.plot.PlotNearbyAreaMapItem;
import com.equestricraft.core.plot.PlotNearbyAreaType;
import com.equestricraft.core.plot.PlotPermissionChecker;
import com.equestricraft.core.plot.PlotPermissionException;
import com.equestricraft.core.plot.PlotPurchaseResponse;
import com.equestricraft.core.plot.PlotRepository;
import com.equestricraft.core.plot.PlotSession;
import com.equestricraft.core.plot.PlotType;
import com.equestricraft.core.plot.access.PlotPlayerAccessSession;
import com.equestricraft.core.plot.approval.PlotActionType;
import com.equestricraft.core.plot.approval.PlotApprovalSession;
import com.equestricraft.core.plot.map.grid.PlotGridMapItem;
import com.equestricraft.core.plot.map.grid.PlotGridMapSession;
import com.equestricraft.core.plot.map.natural.PlotNaturalMapItem;
import com.equestricraft.core.plot.map.natural.PlotNaturalMapSession;
import com.equestricraft.core.plot.setting.PlotGlobalSettings;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.mod.packet.ClientBoundGridPlotPurchaseMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundNaturalPlotPurchaseMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundPlotAccessMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundPlotListMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundPlotMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundPlotMergeMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundPlotMinimapUpdatePacket;
import com.equestricraft.mod.packet.ClientBoundPlotNearbyAreasUpdatePacket;
import com.equestricraft.mod.packet.ClientBoundPlotNearbyMapOpenPacket;
import com.equestricraft.mod.packet.ClientBoundPlotPendingApprovalsMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundPlotPriceCalculationUpdatePacket;
import com.equestricraft.mod.packet.ClientBoundPlotPurchaseRandomNamePacket;
import com.equestricraft.mod.packet.ClientBoundPlotSellMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.plot.InvalidPlotWorldException;
import com.equestricraft.mod.plot.PlotAccessPage;
import com.equestricraft.mod.plot.PlotAccessPageService;
import com.equestricraft.mod.plot.PlotGridResetSession;
import com.equestricraft.mod.plot.PlotGridWorldPurgeSession;
import com.equestricraft.mod.plot.PlotPage;
import com.equestricraft.mod.plot.PlotPageService;
import com.equestricraft.mod.plot.PlotPendingApprovalsPage;
import com.equestricraft.mod.plot.PlotPendingApprovalsPageService;
import com.equestricraft.mod.plot.PlotSellInfo;
import com.equestricraft.mod.plot.PlotService;
import com.equestricraft.mod.plot.worldgen.PlotWorldGenUtil;
import com.equestricraft.mod.prompt.PlayerSearchPrompt;
import com.equestricraft.mod.prompt.TextInputPrompt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PlotServiceImpl
implements PlotService {
    @Service
    private PlotSession plotSession;
    @Service
    private PlotPlayerAccessSession plotPlayerAccessSession;
    @Service
    private PlotRepository plotRepository;
    @Service
    private PlotPageService plotPageService;
    @Service
    private PlotAccessPageService plotAccessPageService;
    @Service
    private PlotApprovalSession plotApprovalSession;
    @Service
    private PlotPendingApprovalsPageService plotPendingApprovalsPageService;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private PlayerTransformer playerTransformer;
    @Service
    private PlotGridResetSession plotGridResetSession;
    @Service
    private PlotGridMapSession plotGridMapSession;
    @Service
    private PlotGridWorldPurgeSession plotGridWorldPurgeSession;
    @Service
    private NameGeneratorSession nameGeneratorSession;
    @Service
    private PlotAreaSession plotAreaSession;
    @Service
    private PlayerSettingsSession playerSettingsSession;
    @Service
    private PlotNaturalMapSession plotNaturalMapSession;
    @Service
    private BlockedPhraseService blockedPhraseService;

    @Override
    public Response showPurchaseMenu(OnlinePlayer player) {
        PlotType type = PlotType.requirePlotTypeForLevel(player.getECLevel());
        if (FeatureFlag.NATURAL_PLOTS.isDisabled() && type == PlotType.NATURAL) {
            return ResponseFactory.fail(I18n.getLabel("plot.not-in-plot-world"));
        }
        DirectionalCoordinate coordinate = player.getLocation().getCurrent().orElseThrow();
        Object packet = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PlotType.GRID -> new ClientBoundGridPlotPurchaseMenuOpenPacket(coordinate);
            case PlotType.NATURAL -> {
                int minimumPlotRadius = PlotGlobalSettings.get().getMinimumPlotRadius();
                yield new ClientBoundNaturalPlotPurchaseMenuOpenPacket(coordinate, minimumPlotRadius);
            }
        };
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public Response purchaseGrid(OnlinePlayer player, DirectionalCoordinate coordinate, String name) {
        try {
            PlotPurchaseResponse response = this.plotSession.purchaseNewGridPlot(player, coordinate, name);
            player.getLocation().teleport(response.plot().getSpawnPoint());
            return ResponseFactory.success(I18n.getLabel("plot.purchase.title"), I18n.getLabel("plot.purchase.success.message", response.economyResponse().amountFormatted(), response.economyResponse().balanceFormatted()));
        }
        catch (PlotException ex) {
            return ResponseFactory.fail(I18n.getLabel("plot.purchase.title"), ex);
        }
    }

    @Override
    public Response purchaseNatural(OnlinePlayer player, DirectionalCoordinate coordinate, String name, int radius) {
        if (FeatureFlag.NATURAL_PLOTS.isDisabled()) {
            return ResponseFactory.fail(I18n.getLabel("plot.not-in-plot-world"));
        }
        try {
            PlotPurchaseResponse response = this.plotSession.purchaseNewNaturalPlot(player, coordinate, name, radius);
            player.getLocation().teleport(response.plot().getSpawnPoint());
            return ResponseFactory.success(I18n.getLabel("plot.purchase.title"), I18n.getLabel("plot.purchase.success.message", response.economyResponse().amountFormatted(), response.economyResponse().balanceFormatted()));
        }
        catch (PlotException ex) {
            return ResponseFactory.fail(I18n.getLabel("plot.purchase.title"), ex);
        }
    }

    private static void ensurePlotWorld(OnlinePlayer player, PlotType plotType) throws InvalidPlotWorldException {
        ECLevel world;
        switch (plotType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NATURAL: {
                ECLevel eCLevel = ECLevel.PLOT_NATURAL;
                break;
            }
            case GRID: {
                ECLevel eCLevel = world = ECLevel.PLOT_GRID;
            }
        }
        if (player.getECLevel() != world) {
            throw new InvalidPlotWorldException();
        }
    }

    @Override
    public void showPlayersPlotMenu(OnlinePlayer player, int pageNumber) {
        PlotPage page = this.plotPageService.retrievePlotPageForPlayer(player, pageNumber);
        ClientBoundPlotListMenuOpenPacket packet = new ClientBoundPlotListMenuOpenPacket(page);
        player.sendPacket(packet);
    }

    @Override
    public Response showCurrentPlotMenu(OnlinePlayer player) {
        Optional<Plot> plot = player.getPlots().getCurrentPlot();
        if (plot.isPresent()) {
            this.showMenuForPlot(player, plot.get());
            return ResponseFactory.success();
        }
        return ResponseFactory.fail(I18n.getLabel("plot.not-in-a-plot"));
    }

    @Override
    public void showPlotMenu(OnlinePlayer player, int plotId) {
        Plot plot = (Plot)this.plotRepository.findByKey(plotId);
        this.showMenuForPlot(player, plot);
    }

    private void showMenuForPlot(OnlinePlayer player, Plot plot) {
        PlotInfo plotSessionInfoForPlot = this.plotSession.createInfoForPlot(plot);
        ClientBoundPlotMenuOpenPacket packet = new ClientBoundPlotMenuOpenPacket(plotSessionInfoForPlot);
        player.sendPacket(packet);
    }

    @Override
    public Response renamePlot(OnlinePlayer player, int plotId) {
        Plot plot = (Plot)this.plotRepository.findByKey(plotId);
        try {
            PlotPermissionChecker.ensureOwnerAccess(player, plot);
            Optional<String> name = TextInputPrompt.showTextInputPrompt(player, I18n.getLabel("plot.rename.title"), I18n.getLabel("plot.rename.enter-new-name"));
            if (name.isPresent()) {
                String n = StringUtils.removeExtraSpaces(name.get());
                this.blockedPhraseService.ensureNoBlockedPhrases(n);
                plot.setName(n);
                plot.save();
                return ResponseFactory.success(I18n.getLabel("plot.rename.title"), I18n.getLabel("plot.rename.success", n));
            }
            return ResponseFactory.fail();
        }
        catch (BlockedPhraseException | PlotException ex) {
            return ResponseFactory.fail(I18n.getLabel("plot.rename.title"), ex);
        }
    }

    @Override
    public void showPlotAccessMenu(OnlinePlayer player, int plotId, int pageNumber) {
        PlotAccessPage page = this.plotAccessPageService.retrieveAccessPage(plotId, pageNumber);
        ClientBoundPlotAccessMenuOpenPacket packet = new ClientBoundPlotAccessMenuOpenPacket(plotId, page);
        player.sendPacket(packet);
    }

    @Override
    public Response teleportToPlot(OnlinePlayer player, int plotId) {
        Plot plot = (Plot)this.plotRepository.findByKey(plotId);
        player.getLocation().teleport(plot.getSpawnPoint());
        return ResponseFactory.success(I18n.getLabel("plot.teleport-to-plot.success"));
    }

    @Override
    public Response setSpawn(OnlinePlayer player) {
        Optional<Plot> plot = player.getPlots().getCurrentPlot();
        if (plot.isPresent()) {
            Plot p = plot.get();
            try {
                PlotPermissionChecker.ensureOwnerAccess(player, p);
                DirectionalCoordinate playersLocation = player.getLocation().getCurrent().orElseThrow();
                p.setSpawnPoint(playersLocation);
                p.save();
                return ResponseFactory.success(I18n.getLabel("plot.set-spawn.success.title"), I18n.getLabel("plot.set-spawn.success.message"));
            }
            catch (PlotPermissionException ex) {
                return ResponseFactory.fail(ex);
            }
        }
        return ResponseFactory.fail(I18n.getLabel("plot.not-in-a-plot"));
    }

    @Override
    public Response grantAccessToPlot(OnlinePlayer player, int plotId) {
        try {
            Plot plot = (Plot)this.plotRepository.findByKey(plotId);
            PlotPermissionChecker.ensureOwnerAccess(player, plot);
            Optional<ECPlayer> playerToGrant = PlayerSearchPrompt.showPlayerSearchPrompt(player);
            if (playerToGrant.isPresent()) {
                ConfirmResponse editAccessResponse = player.getConfirmation().confirm(I18n.getLabel("plot.access.title"), I18n.getLabel("plot.access.should-give-edit.message"));
                if (editAccessResponse.isCancel()) {
                    return ResponseFactory.fail();
                }
                boolean editAccess = editAccessResponse.isYes();
                if (editAccess) {
                    this.plotPlayerAccessSession.grantPlayerEditAccessToPlot(playerToGrant.get(), plot);
                } else {
                    this.plotPlayerAccessSession.grantPlayerAccessToPlot(playerToGrant.get(), plot);
                }
                return ResponseFactory.success(I18n.getLabel("plot.access.title"), I18n.getLabel("plot.access.grant.success", playerToGrant.get().getIgn(), plot.getName()));
            }
            return ResponseFactory.fail();
        }
        catch (PlotPermissionException ex) {
            return ResponseFactory.fail(I18n.getLabel("plot.access.title"), ex);
        }
    }

    @Override
    public Response revokeAccessFromPlot(OnlinePlayer player, int plotId, int playerId) {
        Plot plot = (Plot)this.plotRepository.findByKey(plotId);
        try {
            PlotPermissionChecker.ensureOwnerAccess(player, plot);
            CorePlayer playerToRevoke = (CorePlayer)this.playerRepository.findByKey(playerId);
            this.plotPlayerAccessSession.revokePlayersAccessToPlot(playerToRevoke, plot);
            CorePlayer revokedPlayer = (CorePlayer)this.playerRepository.findByKey(playerId);
            return ResponseFactory.success(I18n.getLabel("plot.access.title"), I18n.getLabel("plot.access.revoke.success", revokedPlayer.getIgn(), plot.getName()));
        }
        catch (PlotPermissionException ex) {
            return ResponseFactory.fail(I18n.getLabel("plot.access.title"), ex);
        }
    }

    @Override
    public boolean shouldBlockInteraction(OnlinePlayer player, PlotType plotType, Point2D point) {
        Optional<Plot> plotAtPoint = this.plotSession.getPlotAtPoint(plotType, point);
        return plotAtPoint.map(plot -> !PlotPermissionChecker.hasEditAccess(player, plot)).orElse(true);
    }

    @Override
    public Response startPlotSell(OnlinePlayer player, int plotId) {
        Optional<ECPlayer> toPlayer = PlayerSearchPrompt.showPlayerSearchPrompt(player);
        if (toPlayer.isPresent()) {
            Plot plot = (Plot)this.plotRepository.findByKey(plotId);
            PlotSellInfo info2 = new PlotSellInfo(plot.getId(), plot.getName(), this.playerTransformer.toSimple(toPlayer.get().getCorePlayer()));
            ClientBoundPlotSellMenuOpenPacket packet = new ClientBoundPlotSellMenuOpenPacket(info2);
            player.sendPacket(packet);
            return ResponseFactory.success();
        }
        return ResponseFactory.fail();
    }

    @Override
    public Response sellPlot(OnlinePlayer player, int plotId, int sellToPlayerId, double price) {
        Plot plot = (Plot)this.plotRepository.findByKey(plotId);
        ConfirmResponse confirmResponse = player.getConfirmation().confirm(I18n.getLabel("plot.sell.title"), I18n.getLabel("plot.sell.confirm", plot.getName(), EconomyUtilities.formatCurrency(price)));
        if (!confirmResponse.isYes()) {
            return ResponseFactory.fail();
        }
        CorePlayer sellToPlayer = (CorePlayer)this.playerRepository.findByKey(sellToPlayerId);
        if (!sellToPlayer.isOnline()) {
            return ResponseFactory.fail(I18n.getLabel("player.not-online", sellToPlayer.getIgn()));
        }
        player.sendMessage(I18n.getLabel("plot.sell.waiting-for-confirmation", sellToPlayer.getIgn()));
        ConfirmResponse newOwnerConfirmation = sellToPlayer.getConfirmation().confirm(I18n.getLabel("plot.buy-from-player.title"), I18n.getLabel("plot.buy-from-player.message", plot.getName(), EconomyUtilities.formatCurrency(price)));
        if (!newOwnerConfirmation.isYes()) {
            return ResponseFactory.fail(I18n.getLabel("plot.sell.title"), I18n.getLabel("plot.sell.player-denied", sellToPlayer.getIgn()));
        }
        try {
            PlotPermissionChecker.ensureOwnerAccess(player, plot);
            return this.plotApprovalSession.executeWithApproval(PlotActionType.SELL, plot, player, () -> {
                this.plotSession.sellPlot(plot, Collections.singletonList(sellToPlayer), price);
                return ResponseFactory.success(I18n.getLabel("plot.sell.title"), I18n.getLabel("plot.sell.success", plot.getName(), sellToPlayer.getIgn()));
            });
        }
        catch (PlotException ex) {
            return ResponseFactory.fail(I18n.getLabel("plot.sell.title"), ex);
        }
    }

    @Override
    public void showPendingApprovalsMenuToPlayer(OnlinePlayer player) {
        this.showPendingApprovalsMenuToPlayer(player, 1);
    }

    @Override
    public void showPendingApprovalsMenuToPlayer(OnlinePlayer player, int pageNumber) {
        PlotPendingApprovalsPage page = this.plotPendingApprovalsPageService.retrieveApprovalsPage(player, pageNumber);
        ClientBoundPlotPendingApprovalsMenuOpenPacket packet = new ClientBoundPlotPendingApprovalsMenuOpenPacket(page);
        player.sendPacket(packet);
    }

    @Override
    public Response acceptApproval(OnlinePlayer player, int plotId, PlotActionType actionType) {
        Plot plot = (Plot)this.plotRepository.findByKey(plotId);
        try {
            return this.plotApprovalSession.provideApproval(plot, actionType, player);
        }
        catch (PlotException ex) {
            return ResponseFactory.fail(I18n.getLabel("plot.approval.fail.title"), ex);
        }
    }

    @Override
    public Response cancelAction(OnlinePlayer player, int plotId, PlotActionType actionType) {
        try {
            Plot plot = (Plot)this.plotRepository.findByKey(plotId);
            PlotPermissionChecker.ensureOwnerAccess(player, plot);
            return this.plotApprovalSession.cancelAction(plot, actionType);
        }
        catch (PlotException ex) {
            return ResponseFactory.fail(I18n.getLabel("plot.approval.fail.title"), ex);
        }
    }

    @Override
    public Response promoteToOwner(OnlinePlayer player, int plotId, int playerId) {
        try {
            Plot plot = (Plot)this.plotRepository.findByKey(plotId);
            PlotPermissionChecker.ensureOwnerAccess(player, plot);
            CorePlayer playerToPromote = (CorePlayer)this.playerRepository.findByKey(playerId);
            if (!playerToPromote.isOnline()) {
                return ResponseFactory.fail(I18n.getLabel("plot.promote-owner.title"), I18n.getLabel("player.not-online"));
            }
            player.sendMessage(I18n.getLabel("plot.prompt-owner.waiting-for-confirmation", playerToPromote.getIgn()));
            ConfirmResponse confirm = playerToPromote.getConfirmation().confirm(I18n.getLabel("plot.promote-owner.confirm.title"), I18n.getLabel("plot.promote-owner.confirm.message", plot.getName()));
            if (!confirm.isYes()) {
                return ResponseFactory.fail(I18n.getLabel("plot.promote-owner.title"), I18n.getLabel("plot.promote-owner.player-did-not-confirm", playerToPromote.getIgn()));
            }
            return this.plotApprovalSession.executeWithApproval(PlotActionType.PROMOTE_OWNER, plot, player, () -> {
                this.plotPlayerAccessSession.revokePlayersAccessToPlot(playerToPromote, plot);
                plot.getOwnerIds().add(playerToPromote.getId());
                plot.save();
                playerToPromote.notify(I18n.getLabel("plot.promote-owner.you-are-now-owner", plot.getName()));
                return ResponseFactory.success(I18n.getLabel("plot.promote-owner.title"), I18n.getLabel("plot.promote-owner.success", playerToPromote.getIgn(), plot.getName()));
            });
        }
        catch (PlotException ex) {
            return ResponseFactory.fail(I18n.getLabel("plot.promote-owner.title"), ex);
        }
    }

    @Override
    public Response stepDownAsOwner(OnlinePlayer player) {
        Optional<Plot> plot = player.getPlots().getCurrentPlot();
        if (plot.isPresent()) {
            Plot p = plot.get();
            try {
                PlotPermissionChecker.ensureOwnerAccess(player, p);
                ConfirmResponse confirm = player.getConfirmation().confirm(I18n.getLabel("plot.step-down-as-owner.title"), I18n.getLabel("plot.step-down-as-owner.confirm", p.getName()));
                if (confirm.isYes()) {
                    this.plotSession.removePlayerAsOwner(p, player);
                    return ResponseFactory.success(I18n.getLabel("plot.step-down-as-owner.title"), I18n.getLabel("plot.step-down-as-owner.success", p.getName()));
                }
                return ResponseFactory.fail();
            }
            catch (PlotException ex) {
                return ResponseFactory.fail(I18n.getLabel("plot.step-down-as-owner.title"), ex);
            }
        }
        return ResponseFactory.fail(I18n.getLabel("plot.step-down-as-owner.title"), I18n.getLabel("plot.not-in-a-plot"));
    }

    @Override
    public Response autoPurchasePlot(OnlinePlayer player) {
        String name = this.nameGeneratorSession.getRandomName();
        return this.autoPurchasePlot(player, name);
    }

    @Override
    public Response autoPurchasePlot(OnlinePlayer player, String name) {
        try {
            PlotPurchaseResponse response = this.plotSession.autoPurchaseGridPlot(player, name);
            player.getLocation().teleport(response.plot().getSpawnPoint());
            return ResponseFactory.success(I18n.getLabel("plot.purchase.title"), I18n.getLabel("plot.purchase.success.message", response.economyResponse().amountFormatted(), response.economyResponse().balanceFormatted()));
        }
        catch (PlotException ex) {
            return ResponseFactory.fail(I18n.getLabel("plot.purchase.title"), ex);
        }
    }

    @Override
    public Response deletePlot(OnlinePlayer player) {
        Optional<Plot> plot = player.getPlots().getCurrentPlot();
        if (plot.isPresent()) {
            Plot p = plot.get();
            ConfirmResponse confirm = player.getConfirmation().confirm(I18n.getLabel("plot.delete.title"), I18n.getLabel("plot.delete.confirm", p.getName()));
            if (confirm.isYes()) {
                try {
                    PlotPermissionChecker.ensureOwnerAccess(player, p);
                    return this.plotApprovalSession.executeWithApproval(PlotActionType.DELETE, p, player, () -> {
                        this.plotSession.deletePlot(p);
                        if (p instanceof GridPlot) {
                            GridPlot gridPlot = (GridPlot)p;
                            this.plotGridResetSession.resetPlot(gridPlot);
                        }
                        this.plotSession.removePlotFromPlayers(p);
                        return ResponseFactory.success(I18n.getLabel("plot.delete.title"), I18n.getLabel("plot.delete.success"));
                    });
                }
                catch (PlotException ex) {
                    return ResponseFactory.fail(I18n.getLabel("plot.delete.title", ex));
                }
            }
            return ResponseFactory.fail();
        }
        return ResponseFactory.fail(I18n.getLabel("plot.delete.title"), I18n.getLabel("plot.not-in-a-plot"));
    }

    @Override
    public Response showMap(OnlinePlayer player) {
        try {
            PlotServiceImpl.ensurePlotWorld(player, PlotType.GRID);
            DirectionalCoordinate position = player.getLocation().getCurrent().orElseThrow();
            Coordinate coordinate = new Coordinate(position.x(), position.y(), position.z(), position.world());
            List<PlotGridMapItem> mapItems = this.plotGridMapSession.retrieveSurroundingMapData(coordinate, player);
            ClientBoundPlotNearbyMapOpenPacket packet = new ClientBoundPlotNearbyMapOpenPacket(mapItems);
            player.sendPacket(packet);
            return ResponseFactory.success();
        }
        catch (PlotException ex) {
            return ResponseFactory.fail(ex);
        }
    }

    @Override
    public Response showMergeMenu(OnlinePlayer player) {
        try {
            PlotServiceImpl.ensurePlotWorld(player, PlotType.GRID);
            Optional<Plot> currentPlot = player.getPlots().getCurrentPlot();
            if (currentPlot.isPresent()) {
                PlotPermissionChecker.ensureOwnerAccess(player, currentPlot.get());
                if (currentPlot.get().getPlotType() != PlotType.GRID) {
                    return ResponseFactory.fail(I18n.getLabel("plot.merge.title"), I18n.getLabel("plot.merge.not-grid-world"));
                }
                GridPlot gridPlot = (GridPlot)currentPlot.get();
                PlotInfo targetPlot = this.plotSession.createInfoForPlot(gridPlot);
                List<PlotInfo> neighbouringPlots = this.plotSession.retrieveNeighbouringPlots(gridPlot);
                ClientBoundPlotMergeMenuOpenPacket packet = new ClientBoundPlotMergeMenuOpenPacket(targetPlot, neighbouringPlots);
                player.sendPacket(packet);
                return ResponseFactory.success();
            }
            return ResponseFactory.fail(I18n.getLabel("plot.merge.title"), I18n.getLabel("plot.not-in-a-plot"));
        }
        catch (PlotException ex) {
            return ResponseFactory.fail("plot.merge.title", ex);
        }
    }

    @Override
    public Response mergePlots(OnlinePlayer player, int targetPlotId, int sourcePlotId) {
        GridPlot targetPlot = (GridPlot)this.plotRepository.findByKey(targetPlotId);
        GridPlot sourcePlot = (GridPlot)this.plotRepository.findByKey(sourcePlotId);
        ConfirmResponse confirmResponse = player.getConfirmation().confirm(I18n.getLabel("plot.merge.title"), I18n.getLabel("plot.merge.confirm", sourcePlot.getName(), targetPlot.getName()));
        if (confirmResponse.isYes()) {
            try {
                PlotPermissionChecker.ensureOwnerAccess(player, sourcePlot);
                PlotPermissionChecker.ensureOwnerAccess(player, targetPlot);
                List<Point2D> pathsToRemove = this.getPathsBetweenPlots(targetPlot, sourcePlot);
                this.plotSession.mergePlotIntoPlot(targetPlot, sourcePlot);
                this.clearBlocks(pathsToRemove);
                return ResponseFactory.success(I18n.getLabel("plot.merge.title"), I18n.getLabel("plot.merge.success"));
            }
            catch (PlotException ex) {
                return ResponseFactory.fail(I18n.getLabel("plot.merge.title", ex));
            }
        }
        return ResponseFactory.fail();
    }

    private List<Point2D> getPathsBetweenPlots(GridPlot plot1, GridPlot plot2) {
        LinkedHashSet<Point2D> positions = new LinkedHashSet<Point2D>();
        positions.addAll(this.getPointsOfPathsToRemove(plot1, plot2));
        positions.addAll(this.getPointsOfPathsToRemove(plot2, plot1));
        return new ArrayList<Point2D>(positions);
    }

    private Set<Point2D> getPointsOfPathsToRemove(GridPlot plot, GridPlot otherPlot) {
        LinkedHashSet<Point2D> positions = new LinkedHashSet<Point2D>();
        for (PlotCoordinate area : plot.getAreas()) {
            boolean south = otherPlot.getAreas().contains(area.south());
            boolean east = otherPlot.getAreas().contains(area.east());
            boolean southEast = otherPlot.getAreas().contains(area.south().east());
            if (south) {
                positions.addAll(this.getPointsInRanges(Range.of(area.getPlotStartX(), area.getPlotEndX()), Range.of(area.getPathStartZ(), area.getPathEndZ())));
            }
            if (east) {
                positions.addAll(this.getPointsInRanges(Range.of(area.getPathStartX(), area.getPathEndX()), Range.of(area.getPlotStartZ(), area.getPlotEndZ())));
            }
            if (!south || !southEast || !east) continue;
            positions.addAll(this.getPointsInRanges(Range.of(area.getPathStartX(), area.getPathEndX()), Range.of(area.getPathStartZ(), area.getPathEndZ())));
        }
        return positions;
    }

    private Set<Point2D> getPointsInRanges(Range<Integer> xRange, Range<Integer> zRange) {
        LinkedHashSet<Point2D> positions = new LinkedHashSet<Point2D>(xRange.getDistance().getIntDistance() * zRange.getDistance().getIntDistance());
        for (int x = xRange.getLowerBound().intValue(); x <= xRange.getUpperBound(); ++x) {
            for (int z = zRange.getLowerBound().intValue(); z <= zRange.getUpperBound(); ++z) {
                Point2D point = new Point2D(x, z);
                positions.add(point);
            }
        }
        return positions;
    }

    private void clearBlocks(List<Point2D> points) {
        List<List<Point2D>> batches = ListUtils.batch(points, 100);
        for (List<Point2D> batch : batches) {
            TaskScheduler.executeSyncTask(() -> batch.forEach(PlotWorldGenUtil::clearWall));
        }
    }

    @Override
    public Response purgeWorld(OnlinePlayer player) {
        ConfirmResponse confirmResponse = player.getConfirmation().confirm(I18n.getLabel("plot.world-purge.title"), I18n.getLabel("plot.world-purge.confirm"));
        if (confirmResponse.isYes()) {
            player.sendMessage(I18n.getLabel("plot.world-purge.started"));
            this.plotGridWorldPurgeSession.purgePlotWorld();
            return ResponseFactory.success(I18n.getLabel("plot.world-purge.completed"));
        }
        return ResponseFactory.fail();
    }

    @Override
    public void sendRandomPlotPurchaseName(OnlinePlayer player) {
        String name = this.nameGeneratorSession.getRandomName();
        ClientBoundPlotPurchaseRandomNamePacket packet = new ClientBoundPlotPurchaseRandomNamePacket(name);
        player.sendPacket(packet);
    }

    @Override
    public Response sendPlayerToPlotWorld(OnlinePlayer player) {
        if (FeatureFlag.NATURAL_PLOTS.isDisabled()) {
            return ResponseFactory.fail();
        }
        if (player.getECLevel() == ECLevel.PLOT_NATURAL) {
            return ResponseFactory.fail(I18n.getLabel("plot.world.teleport.already-in"));
        }
        DirectionalCoordinate spawnPoint = PlotGlobalSettings.get().getSpawnPoint();
        player.getLocation().teleport(spawnPoint);
        return ResponseFactory.success(I18n.getLabel("plot.world.teleport.success"));
    }

    @Override
    public void sendPriceCalculationUpdate(OnlinePlayer player, int radius) {
        double price = this.plotSession.calculateCost(radius);
        String formattedPrice = EconomyUtilities.formatCurrency(price);
        ClientBoundPlotPriceCalculationUpdatePacket packet = new ClientBoundPlotPriceCalculationUpdatePacket(formattedPrice);
        player.sendPacket(packet);
    }

    @Override
    public void sendNearbyAreasUpdate(OnlinePlayer player, int x, int z, int radius) {
        Area2D targetArea = AreaUtility.createAreaFromPointAndRadius(new Point2D(x, z), radius);
        List<PlotNearbyAreaMapItem> nearbyPlots = this.plotAreaSession.retrieveNearbyConflictAreas(targetArea);
        ArrayList<PlotNearbyAreaMapItem> items = new ArrayList<PlotNearbyAreaMapItem>(nearbyPlots.size() + 1);
        items.add(new PlotNearbyAreaMapItem(Collections.singletonList(targetArea), PlotNearbyAreaType.TARGET, false));
        items.addAll(nearbyPlots);
        ClientBoundPlotNearbyAreasUpdatePacket packet = new ClientBoundPlotNearbyAreasUpdatePacket(items);
        player.sendPacket(packet);
    }

    @Override
    public void sendMinimapUpdate(OnlinePlayer player) {
        boolean shouldShow = this.playerSettingsSession.getSettingsForPlayer(player).showPlotMinimap();
        List<PlotNaturalMapItem> items = null;
        if (shouldShow && player.getECLevel() == ECLevel.PLOT_NATURAL) {
            DirectionalCoordinate location = player.getLocation().getCurrent().orElseThrow();
            Point2D point = new Point2D((int)location.x(), (int)location.z());
            items = this.plotNaturalMapSession.retrieveNaturalPlotMapItems(player, point);
        }
        ClientBoundPlotMinimapUpdatePacket packet = new ClientBoundPlotMinimapUpdatePacket(items);
        player.sendPacket(packet);
    }

    @Override
    public Response togglePlotChat(OnlinePlayer player) {
        boolean isActive = player.getPlots().togglePlotChat();
        String message = isActive ? I18n.getLabel("plot.chat.enabled") : I18n.getLabel("plot.chat.disabled");
        return ResponseFactory.success(message);
    }
}

