/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.plot.worldgen;

import com.equestricraft.common.coordinate.Point2D;
import com.equestricraft.core.plot.PlotCoordinateUtility;
import com.equestricraft.mod.plot.worldgen.PlotGridLevelGeneratorSettings;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class PlotGridChunkGenerator
extends ChunkGenerator {
    public static final Codec<PlotGridChunkGenerator> CODEC = RecordCodecBuilder.create(g -> PlotGridChunkGenerator.m_208005_((RecordCodecBuilder.Instance)g).and((App)PlotGridLevelGeneratorSettings.CODEC.fieldOf("settings").forGetter(p -> p.settings)).apply((Applicative)g, g.stable(PlotGridChunkGenerator::new)));
    private final PlotGridLevelGeneratorSettings settings;

    public PlotGridChunkGenerator(Registry<StructureSet> structureSets, PlotGridLevelGeneratorSettings settings) {
        super(structureSets, Optional.empty(), (BiomeSource)new FixedBiomeSource(settings.getBiomeFromSettings()), (BiomeSource)new FixedBiomeSource(settings.getBiome()), 0L);
        this.settings = settings;
    }

    public void m_62199_(RegistryAccess registryAccess, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess, StructureManager structureManager, long value) {
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkGenerator m_6819_(long seed) {
        return this;
    }

    public void m_183621_(WorldGenRegion region, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess) {
        ChunkPos chunkPos = chunkAccess.m_7697_();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Point2D point = new Point2D(chunkPos.m_45604_() + x, chunkPos.m_45605_() + z);
                if (PlotCoordinateUtility.isPlotPath(point)) {
                    for (int i = 0; i <= 3; ++i) {
                        chunkAccess.m_6978_(new BlockPos(x, 65 + i, z), Blocks.f_50069_.m_49966_(), false);
                    }
                    continue;
                }
                if (!PlotCoordinateUtility.isCenterLine(point)) continue;
                chunkAccess.m_6978_(new BlockPos(x, 64, z), Blocks.f_50069_.m_49966_(), false);
            }
        }
    }

    public int m_142051_(LevelHeightAccessor levelHeightAccessor) {
        return levelHeightAccessor.m_141937_() + Math.min(levelHeightAccessor.m_141928_(), this.settings.getLayers().size());
    }

    protected Holder<Biome> m_203427_(Holder<Biome> biomeHolder) {
        return this.settings.getBiome();
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess) {
        List<BlockState> list = this.settings.getLayers();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        Heightmap heightmap = chunkAccess.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunkAccess.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        for (int i = 0; i < Math.min(chunkAccess.m_141928_(), list.size()); ++i) {
            BlockState blockState = list.get(i);
            if (blockState == null) continue;
            int j = chunkAccess.m_141937_() + i;
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    chunkAccess.m_6978_((BlockPos)blockPos.m_122178_(k, j, l), blockState, false);
                    heightmap.m_64249_(k, j, l, blockState);
                    heightmap1.m_64249_(k, j, l, blockState);
                }
            }
        }
        return CompletableFuture.completedFuture(chunkAccess);
    }

    public int m_142647_(int val1, int val2, Heightmap.Types heightMapType, LevelHeightAccessor levelHeightAccessor) {
        List<BlockState> list = this.settings.getLayers();
        for (int i = Math.min(list.size(), levelHeightAccessor.m_151558_()) - 1; i >= 0; --i) {
            BlockState blockState = list.get(i);
            if (blockState == null || !heightMapType.m_64299_().test(blockState)) continue;
            return levelHeightAccessor.m_141937_() + i + 1;
        }
        return levelHeightAccessor.m_141937_();
    }

    public NoiseColumn m_141914_(int val1, int val2, LevelHeightAccessor levelHeightAccessor) {
        return new NoiseColumn(levelHeightAccessor.m_141937_(), (BlockState[])this.settings.getLayers().stream().limit(levelHeightAccessor.m_141928_()).map(v -> v == null ? Blocks.f_50016_.m_49966_() : v).toArray(BlockState[]::new));
    }

    public void m_207076_(List<String> list, BlockPos pos) {
    }

    public Climate.Sampler m_183403_() {
        return Climate.m_207841_();
    }

    public void m_183516_(WorldGenRegion worldGenRegion, long val, BiomeManager biomeManager, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess, GenerationStep.Carving generationStepCarving) {
    }

    public void m_6929_(WorldGenRegion worldGenRegion) {
    }

    public int m_142062_() {
        return 0;
    }

    public int m_6331_() {
        return 384;
    }

    public int m_6337_() {
        return -63;
    }
}

