/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.plot.worldgen;

import com.equestricraft.mod.plot.worldgen.PlotLayerInfo;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.LayerConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class PlotGridLevelGeneratorSettings {
    public static final Codec<PlotGridLevelGeneratorSettings> CODEC = RecordCodecBuilder.create(p -> p.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(g -> g.biomes)).apply((Applicative)p, PlotGridLevelGeneratorSettings::new)).comapFlatMap(PlotGridLevelGeneratorSettings::validateHeight, Function.identity()).stable();
    private final Registry<Biome> biomes;
    private final List<PlotLayerInfo> layersInfo;
    private Holder<Biome> biome;
    private final List<BlockState> layers;

    private static DataResult<PlotGridLevelGeneratorSettings> validateHeight(PlotGridLevelGeneratorSettings settings) {
        int i = settings.layersInfo.stream().mapToInt(PlotLayerInfo::getHeight).sum();
        return i > DimensionType.f_156651_ ? DataResult.error((String)("Sum of layer heights is > " + DimensionType.f_156651_), (Object)settings) : DataResult.success((Object)settings);
    }

    public PlotGridLevelGeneratorSettings(Registry<Biome> biomes) {
        this.biomes = biomes;
        this.biome = biomes.m_203538_(Biomes.f_48202_);
        this.layersInfo = PlotGridLevelGeneratorSettings.createLayers();
        this.layers = new ArrayList<BlockState>();
        this.updateLayers();
    }

    private static List<PlotLayerInfo> createLayers() {
        ArrayList<PlotLayerInfo> layers = new ArrayList<PlotLayerInfo>(4);
        layers.add(new PlotLayerInfo(Blocks.f_50752_, 1));
        layers.add(new PlotLayerInfo(Blocks.f_50069_, 119));
        layers.add(new PlotLayerInfo(Blocks.f_50493_, 8));
        layers.add(new PlotLayerInfo(Blocks.f_50440_, 1));
        return layers;
    }

    public Holder<Biome> getBiomeFromSettings() {
        Biome b = (Biome)this.biome.m_203334_();
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder();
        for (int i = 0; i < this.layers.size(); ++i) {
            BlockState state = this.layers.get(i);
            if (Heightmap.Types.MOTION_BLOCKING.m_64299_().test(state)) continue;
            this.layers.set(i, null);
            builder.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, PlacementUtils.m_206502_((Feature)Feature.f_65750_, (FeatureConfiguration)new LayerConfiguration(i, state), (PlacementModifier[])new PlacementModifier[0]));
        }
        return Holder.m_205709_((Object)((Biome)Biome.BiomeBuilder.m_204185_((Biome)b).m_47601_(builder.m_47831_()).m_47592_().setRegistryName(b.getRegistryName())));
    }

    public void updateLayers() {
        this.layers.clear();
        for (PlotLayerInfo info2 : this.layersInfo) {
            for (int i = 0; i < info2.getHeight(); ++i) {
                this.layers.add(info2.getBlockState());
            }
        }
    }

    public Holder<Biome> getBiome() {
        return this.biome;
    }

    public List<BlockState> getLayers() {
        return this.layers;
    }
}

