/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.plot.worldgen;

import com.equestricraft.common.coordinate.Point2D;
import com.equestricraft.mod.util.ServerLevelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PlotWorldGenUtil {
    public static void setPoint(Point2D point) {
        ServerLevel plotGridLevel = ServerLevelUtil.getPlotGrid();
        for (int y = -64; y < 512; ++y) {
            BlockPos pos = new BlockPos(point.x(), y, point.z());
            BlockState state = PlotWorldGenUtil.getBlockStateForYLevel(y);
            plotGridLevel.m_46597_(pos, state);
        }
    }

    public static void clearWall(Point2D point) {
        ServerLevel plotGridLevel = ServerLevelUtil.getPlotGrid();
        for (int y = 65; y < 70; ++y) {
            BlockPos pos = new BlockPos(point.x(), y, point.z());
            plotGridLevel.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
        }
    }

    private static BlockState getBlockStateForYLevel(int y) {
        if (y == -64) {
            return Blocks.f_50752_.m_49966_();
        }
        if (y <= 120) {
            return Blocks.f_50069_.m_49966_();
        }
        if (y <= 128) {
            return Blocks.f_50493_.m_49966_();
        }
        if (y == 129) {
            return Blocks.f_50440_.m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    private PlotWorldGenUtil() {
    }
}

