/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.privatemessage;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.mod.privatemessage.PrivateMessageService;
import java.util.Optional;

public class PrivateMessageServiceImpl
implements PrivateMessageService {
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();

    @Override
    public Response sendPrivateMessageToPlayer(ECPlayer sender, String ign, String message) {
        Optional<ECPlayer> playerToSendTo = this.onlinePlayerCache.getPlayer(ign);
        return playerToSendTo.map(serverPlayer -> this.sendMessageToPlayer(sender, (ECPlayer)serverPlayer, message)).orElseGet(() -> ResponseFactory.fail(I18n.getLabel("player.not-online")));
    }

    @Override
    public Response replyToLastPlayer(ECPlayer sender, String message) {
        Optional<ECPlayer> lastMessagedPlayer = sender.getPrivateMessages().getLastMessagedPlayer();
        if (lastMessagedPlayer.isPresent()) {
            return lastMessagedPlayer.filter(ECPlayer::isOnline).map(receiver -> this.sendMessageToPlayer(sender, (ECPlayer)receiver, message)).orElseGet(() -> ResponseFactory.fail(I18n.getLabel("player.not-online")));
        }
        return ResponseFactory.fail(I18n.getLabel("private-message.no-player-to-reply"));
    }

    private Response sendMessageToPlayer(ECPlayer sender, ECPlayer receiver, String message) {
        String toReceiver = this.buildToReceiverMessage(sender, message);
        receiver.sendMessage(toReceiver);
        String toSender = this.buildToSenderMessage(receiver, message);
        sender.sendMessage(toSender);
        sender.getPrivateMessages().setLastMessagedPlayer(receiver);
        receiver.getPrivateMessages().setLastMessagedPlayer(sender);
        return ResponseFactory.success();
    }

    private String buildToReceiverMessage(ECPlayer sender, String message) {
        return I18n.getLabel("private-message.player-to-me", sender.getDisplayName(), message);
    }

    private String buildToSenderMessage(ECPlayer receiver, String message) {
        return I18n.getLabel("private-message.me-to-player", receiver.getDisplayName(), message);
    }
}

