/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.progressbar;

import com.equestricraft.base.eventbus.ECEventBusListener;
import com.equestricraft.core.player.progression.ProgressionChangeEvent;
import com.equestricraft.core.rank.Rank;
import com.equestricraft.mod.player.ECPlayerJoinEvent;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class ProgressBarListener {
    @ECEventBusListener
    public static void onXpChange(ProgressionChangeEvent event) {
        Integer percentage = null;
        if (event.getXpToNextRank() != null) {
            int xpThroughCurrent = event.getCurrentXpValue() - event.getCurrentRank().getXpThreshold();
            int total = xpThroughCurrent + event.getXpToNextRank();
            percentage = (int)((double)xpThroughCurrent / (double)total * 100.0);
        }
        OnlinePlayer onlinePlayer = event.getPlayer().require(OnlinePlayer.class);
        onlinePlayer.getDisplay().getProgressBar().updateProgressBar(event.getXpAdded(), percentage, event.getCurrentRank().getColor());
    }

    @SubscribeEvent
    public static void onPlayerJoin(ECPlayerJoinEvent event) {
        Rank currentRank = event.getPlayer().getProgression().getRank();
        Optional<Integer> xpUntilNextRank = event.getPlayer().getProgression().getXpUntilNextRank();
        Integer percentage = null;
        if (xpUntilNextRank.isPresent()) {
            int xpThroughCurrent = event.getPlayer().getProgression().getXp() - currentRank.getXpThreshold();
            int total = xpThroughCurrent + xpUntilNextRank.get();
            percentage = (int)((double)xpThroughCurrent / (double)total * 100.0);
        }
        event.getPlayer().getDisplay().getProgressBar().updateProgressBar(0, percentage, currentRank.getColor());
    }

    private ProgressBarListener() {
    }
}

