/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.prompt;

import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.packet.ClientBoundConfirmPromptOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.PromptResponseHandler;
import com.equestricraft.mod.prompt.PromptResponsesHandler;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class ConfirmPrompt {
    private static final PromptResponsesHandler promptResponsesHandler = PromptResponsesHandler.getInstance();
    private static final Log log = Log.getLogger(ConfirmPrompt.class.getName());

    public static ConfirmResponse showConfirmPrompt(OnlinePlayer player, String title, String text) {
        try {
            CompletableFuture<ConfirmResponse> result = ConfirmPrompt.showAsyncConfirmPrompt(player, title, text);
            return result.get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return ConfirmResponse.CANCEL;
        }
        catch (ExecutionException ex) {
            log.error(String.format("Error with confirm prompt for. Player: %s. Title: %s", player.getIgn(), title), ex);
            return ConfirmResponse.CANCEL;
        }
    }

    public static CompletableFuture<ConfirmResponse> showAsyncConfirmPrompt(OnlinePlayer player, String title, String text) {
        Objects.requireNonNull(title, "Must supply a title for the prompt");
        Objects.requireNonNull(text, "Must supply text for the prompt");
        PromptResponseHandler handler = promptResponsesHandler.initResponse(player);
        ClientBoundConfirmPromptOpenPacket packet = new ClientBoundConfirmPromptOpenPacket(handler.uuid(), title, text);
        boolean isOnline = player.sendPacket(packet);
        if (!isOnline) {
            handler.future().complete(ConfirmResponse.CANCEL);
        }
        return handler.future();
    }

    private ConfirmPrompt() {
    }
}

