/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.prompt;

import com.equestricraft.base.response.Response;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.response.ResponseHandler;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.packet.ClientBoundMessagePromptOpenPacket;
import com.equestricraft.mod.prompt.PromptResponseHandler;
import com.equestricraft.mod.prompt.PromptResponsesHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class MessagePrompt {
    private static final PromptResponsesHandler promptResponsesHandler = PromptResponsesHandler.getInstance();
    private static final Log log = Log.getLogger(MessagePrompt.class.getName());

    public static Boolean showInfoPrompt(ECPlayer player, String title, String text) {
        return MessagePrompt.showInfoPrompt(player, title, text, null);
    }

    public static Boolean showInfoPrompt(ECPlayer player, String title, String text, Supplier<Object> onOk) {
        return MessagePrompt.showMessagePrompt(player, title, text, MessagePromptType.INFO, onOk);
    }

    public static Boolean showAlertPrompt(ECPlayer player, String title, String text) {
        return MessagePrompt.showAlertPrompt(player, title, text, null);
    }

    public static Boolean showAlertPrompt(ECPlayer player, String title, String text, Supplier<Object> onOk) {
        return MessagePrompt.showMessagePrompt(player, title, text, MessagePromptType.ALERT, onOk);
    }

    public static Boolean showErrorPrompt(ECPlayer player, String title, String text) {
        return MessagePrompt.showErrorPrompt(player, title, text, null);
    }

    public static Boolean showErrorPrompt(ECPlayer player, String title, String text, Supplier<Object> onOk) {
        return MessagePrompt.showMessagePrompt(player, title, text, MessagePromptType.ERROR, onOk);
    }

    public static Boolean showMessagePrompt(ECPlayer player, String title, String text, MessagePromptType messagePromptType, Supplier<Object> onOk) {
        try {
            Object obj;
            CompletableFuture<Boolean> future = MessagePrompt.showMessagePromptImpl(player, title, text, messagePromptType);
            Boolean result = future.get();
            if (Boolean.TRUE.equals(result) && onOk != null && (obj = onOk.get()) instanceof Response) {
                Response response = (Response)obj;
                ResponseHandler.handleResponse(player, response);
            }
            return result;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException ex) {
            log.error("Error with message prompt", ex);
            return false;
        }
    }

    private static CompletableFuture<Boolean> showMessagePromptImpl(ECPlayer player, String title, String text, MessagePromptType messagePromptType) {
        PromptResponseHandler handler = promptResponsesHandler.initResponse(player);
        ClientBoundMessagePromptOpenPacket packet = new ClientBoundMessagePromptOpenPacket(handler.uuid(), title, text, messagePromptType);
        boolean isOnline = player.sendPacket(packet);
        if (!isOnline) {
            handler.future().complete(false);
        }
        return handler.future();
    }

    private MessagePrompt() {
    }

    public static enum MessagePromptType {
        INFO(Resources.getTextures().getGui().get("info.png")),
        ALERT(Resources.getTextures().getGui().get("alert.png")),
        ERROR(Resources.getTextures().getGui().get("error.png"));

        private final ResourceLocation texture;

        private MessagePromptType(ResourceLocation location) {
            this.texture = location;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }
    }
}

