/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.prompt;

import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.packet.ClientBoundMultiSelectOptionPromptOpenPacket;
import com.equestricraft.mod.prompt.OptionPromptItem;
import com.equestricraft.mod.prompt.OptionPromptItemData;
import com.equestricraft.mod.prompt.PromptResponseHandler;
import com.equestricraft.mod.prompt.PromptResponsesHandler;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class MultiSelectionOptionPrompt {
    private static final PromptResponsesHandler promptResponsesHandler = PromptResponsesHandler.getInstance();
    private static final Log log = Log.getLogger(MultiSelectionOptionPrompt.class.getName());

    public static <T> Optional<List<T>> showOptionPrompt(ECPlayer player, List<T> options, Function<T, OptionPromptItem<T>> mapFunction, String title, String text) {
        try {
            CompletableFuture<List<T>> result = MultiSelectionOptionPrompt.showAsyncOptionPrompt(player, options, mapFunction, title, text);
            return Optional.ofNullable(result.get());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
        catch (ExecutionException ex) {
            log.error(String.format("Error with multi selection option prompt. Player: %s. Title: %s", player.getIgn(), title), ex);
            return Optional.empty();
        }
    }

    public static <T> CompletableFuture<List<T>> showAsyncOptionPrompt(ECPlayer player, List<T> options, Function<T, OptionPromptItem<T>> mapFunction, String title, String text) {
        List optionItems = options.stream().map(mapFunction).toList();
        List<OptionPromptItemData> data = optionItems.stream().map(o -> new OptionPromptItemData(o.getId(), o.getName(), o.getDescription())).toList();
        PromptResponseHandler handler = promptResponsesHandler.initResponse(player);
        ClientBoundMultiSelectOptionPromptOpenPacket packet = new ClientBoundMultiSelectOptionPromptOpenPacket(handler.uuid(), title, text, data);
        boolean isOnline = player.sendPacket(packet);
        if (!isOnline) {
            handler.future().complete(null);
        }
        return handler.future().thenApply(ids -> {
            if (ids == null) {
                return null;
            }
            return optionItems.stream().filter(o -> ids.contains(o.getId())).map(OptionPromptItem::getItem).toList();
        });
    }

    private MultiSelectionOptionPrompt() {
    }
}

