/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.prompt;

import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.packet.ClientBoundNumberPromptOpenPacket;
import com.equestricraft.mod.prompt.PromptResponseHandler;
import com.equestricraft.mod.prompt.PromptResponsesHandler;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class NumberInputPrompt {
    private static final PromptResponsesHandler promptResponsesHandler = PromptResponsesHandler.getInstance();
    private final String title;
    private final String text;
    private final Integer minimumValue;
    private final Integer maximumValue;
    private final Integer decimalPoints;
    private static final Log log = Log.getLogger(NumberInputPrompt.class.getName());

    private NumberInputPrompt(String title, String text, Integer minimumValue, Integer maximumValue, Integer decimalPoints) {
        this.title = title;
        this.text = text;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.decimalPoints = decimalPoints;
    }

    public Optional<Number> show(ECPlayer player) {
        try {
            CompletableFuture<Number> result = this.showAsync(player);
            return Optional.ofNullable(result.get());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
        catch (ExecutionException ex) {
            log.error(String.format("Error with number input prompt. Player: %s. Title: %s", player.getIgn(), this.title), ex);
            return Optional.empty();
        }
    }

    public CompletableFuture<Number> showAsync(ECPlayer player) {
        PromptResponseHandler handler = promptResponsesHandler.initResponse(player);
        ClientBoundNumberPromptOpenPacket packet = new ClientBoundNumberPromptOpenPacket(handler.uuid(), this.title, this.text, this.minimumValue, this.maximumValue, this.decimalPoints);
        boolean isOnline = player.sendPacket(packet);
        if (!isOnline) {
            handler.future().complete(null);
        }
        return handler.future();
    }

    public static Optional<Number> showNumberInputPrompt(ECPlayer player, String title, String text) {
        return NumberInputPrompt.create().withTitle(title).withText(text).build().show(player);
    }

    public static CompletableFuture<Number> showAsyncNumberInputPrompt(ECPlayer player, String title, String text) {
        return NumberInputPrompt.create().withTitle(title).withText(text).build().showAsync(player);
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private String title;
        private String text;
        private Integer minimumValue;
        private Integer maximumValue;
        private Integer decimalPoints;

        private Builder() {
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withText(String text) {
            this.text = text;
            return this;
        }

        public Builder withMinimumValue(Integer minimumValue) {
            this.minimumValue = minimumValue;
            return this;
        }

        public Builder withMaximumValue(Integer maximumValue) {
            this.maximumValue = maximumValue;
            return this;
        }

        public Builder withDecimalPoints(Integer decimalPoints) {
            this.decimalPoints = decimalPoints;
            return this;
        }

        public NumberInputPrompt build() {
            return new NumberInputPrompt(Objects.requireNonNull(this.title, "Must provide a title"), Objects.requireNonNull(this.text, "Must provide some text"), this.minimumValue, this.maximumValue, this.decimalPoints);
        }
    }
}

