/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.prompt;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.packet.ClientBoundPlayerSearchMenuOpenPacket;
import com.equestricraft.mod.player.search.PlayerSearchPage;
import com.equestricraft.mod.player.search.PlayerSearchRequest;
import com.equestricraft.mod.prompt.PromptResponseHandler;
import com.equestricraft.mod.prompt.PromptResponsesHandler;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class PlayerSearchPrompt {
    @Service
    private static PlayerRepository playerRepository;
    private static final PromptResponsesHandler promptResponsesHandler;
    private static final Log log;

    public static Optional<ECPlayer> showPlayerSearchPrompt(ECPlayer player) {
        try {
            CompletableFuture<CorePlayer> result = PlayerSearchPrompt.showAsyncPlayerSearchPrompt(player);
            return Optional.ofNullable((ECPlayer)result.get());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
        catch (ExecutionException ex) {
            log.error(String.format("Error with player search prompt. Player: %s", player.getIgn()), ex);
            return Optional.empty();
        }
    }

    public static CompletableFuture<CorePlayer> showAsyncPlayerSearchPrompt(ECPlayer player) {
        PromptResponseHandler handler = promptResponsesHandler.initResponse(player);
        ClientBoundPlayerSearchMenuOpenPacket packet = new ClientBoundPlayerSearchMenuOpenPacket(handler.uuid(), new PlayerSearchPage(Collections.emptyList(), 1, 1, SortDirection.ASCENDING, (Object)null, new PlayerSearchRequest("", false, false)));
        boolean isOnline = player.sendPacket(packet);
        if (!isOnline) {
            handler.future().complete(null);
        }
        return handler.future().thenApply(id -> {
            if (id == null) {
                return null;
            }
            return (CorePlayer)playerRepository.findByKey(id);
        });
    }

    private PlayerSearchPrompt() {
    }

    static {
        promptResponsesHandler = PromptResponsesHandler.getInstance();
        log = Log.getLogger(PlayerSearchPrompt.class.getName());
    }
}

