/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.prompt;

import com.equestricraft.common.ListMap;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.prompt.PromptResponseHandler;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class PromptResponsesHandler {
    private static final PromptResponsesHandler instance = new PromptResponsesHandler();
    private final ListMap<UUID, PromptResponseHandler<?>> responsesMap = new ListMap();

    public static PromptResponsesHandler getInstance() {
        return instance;
    }

    private PromptResponsesHandler() {
    }

    public synchronized <T> void provideResponse(ECPlayer player, UUID uuid, T t) {
        List<PromptResponseHandler<?>> responses = this.responsesMap.get(player.getAccountUuid());
        PromptResponseHandler response = responses.stream().filter(r -> r.uuid().equals(uuid)).findFirst().orElseThrow();
        this.responsesMap.remove(player.getAccountUuid(), response);
        response.future().complete(t);
    }

    public synchronized <T> PromptResponseHandler<T> initResponse(ECPlayer player) {
        UUID uuid = UUID.randomUUID();
        CompletableFuture future = new CompletableFuture();
        PromptResponseHandler handler = new PromptResponseHandler(uuid, future);
        this.responsesMap.add(player.getAccountUuid(), handler);
        return handler;
    }

    public synchronized void clearPlayersResponseHandlers(ECPlayer player) {
        this.responsesMap.clear(player.getAccountUuid());
    }
}

