/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.prompt;

import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.packet.ClientBoundTextPromptOpenPacket;
import com.equestricraft.mod.prompt.PromptResponseHandler;
import com.equestricraft.mod.prompt.PromptResponsesHandler;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class TextInputPrompt {
    private static final PromptResponsesHandler promptResponsesHandler = PromptResponsesHandler.getInstance();
    private final String title;
    private final String text;
    private final Integer minimumLength;
    private final Integer maximumLength;
    private final String defaultValue;
    private static final Log log = Log.getLogger(TextInputPrompt.class.getName());

    private TextInputPrompt(String title, String text, Integer minimumLength, Integer maximumLength, String defaultValue) {
        this.title = title;
        this.text = text;
        this.minimumLength = minimumLength;
        this.maximumLength = maximumLength;
        this.defaultValue = defaultValue;
    }

    public Optional<String> show(ECPlayer player) {
        try {
            CompletableFuture<String> result = this.showAsync(player);
            return Optional.ofNullable(result.get());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
        catch (ExecutionException ex) {
            log.error(String.format("Error with text input prompt. Player: %s. Title: %s", player.getIgn(), this.title), ex);
            return Optional.empty();
        }
    }

    public CompletableFuture<String> showAsync(ECPlayer player) {
        PromptResponseHandler handler = promptResponsesHandler.initResponse(player);
        ClientBoundTextPromptOpenPacket packet = new ClientBoundTextPromptOpenPacket(handler.uuid(), this.title, this.text, this.minimumLength, this.maximumLength, this.defaultValue);
        boolean isOnline = player.sendPacket(packet);
        if (!isOnline) {
            handler.future().complete(null);
        }
        return handler.future();
    }

    public static Optional<String> showTextInputPrompt(ECPlayer player, String title, String text) {
        return TextInputPrompt.create().withTitle(title).withText(text).build().show(player);
    }

    public static CompletableFuture<String> showAsyncTextInputPrompt(ECPlayer player, String title, String text) {
        return TextInputPrompt.create().withTitle(title).withText(text).build().showAsync(player);
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private String title;
        private String text;
        private Integer minimumLength;
        private Integer maximumLength;
        private String defaultValue;

        private Builder() {
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withText(String text) {
            this.text = text;
            return this;
        }

        public Builder withMinimumLength(Integer minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        public Builder withMaximumLength(Integer maximumLength) {
            this.maximumLength = maximumLength;
            return this;
        }

        public Builder withDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public TextInputPrompt build() {
            return new TextInputPrompt(Objects.requireNonNull(this.title, "Must provide a title"), Objects.requireNonNull(this.text, "Must provide some text"), this.minimumLength, this.maximumLength, this.defaultValue);
        }
    }
}

