/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.prompt;

import com.equestricraft.logging.Log;
import com.equestricraft.mod.packet.ClientBoundTransactionEnterMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.PromptResponseHandler;
import com.equestricraft.mod.prompt.PromptResponsesHandler;
import com.equestricraft.mod.prompt.TransactionDetails;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class TransactionDetailsEnterPrompt {
    private static final PromptResponsesHandler promptResponsesHandler = PromptResponsesHandler.getInstance();
    private static final Log log = Log.getLogger(TransactionDetailsEnterPrompt.class.getName());

    public static Optional<TransactionDetails> showTransactionDetailsPrompt(OnlinePlayer player, String message) {
        try {
            CompletableFuture<TransactionDetails> result = TransactionDetailsEnterPrompt.showAsyncTransactionDetailsPrompt(player, message);
            return Optional.ofNullable(result.get());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
        catch (ExecutionException ex) {
            log.error(String.format("Error with transaction details prompt. Player: %s", player.getIgn()), ex);
            return Optional.empty();
        }
    }

    public static CompletableFuture<TransactionDetails> showAsyncTransactionDetailsPrompt(OnlinePlayer player, String message) {
        PromptResponseHandler handler = promptResponsesHandler.initResponse(player);
        ClientBoundTransactionEnterMenuOpenPacket packet = new ClientBoundTransactionEnterMenuOpenPacket(handler.uuid(), message);
        boolean isOnline = player.sendPacket(packet);
        if (!isOnline) {
            handler.future().complete(null);
        }
        return handler.future();
    }

    private TransactionDetailsEnterPrompt() {
    }
}

