/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.provision;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.ECLevel;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.provision.ProvisionGiveException;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.provision.ProvisionInventoryItemSession;
import com.equestricraft.core.player.provision.ProvisionTypeInventoryDetails;
import com.equestricraft.core.provision.Provision;
import com.equestricraft.core.provision.ProvisionRepository;
import com.equestricraft.mod.client.item.ModItems;
import com.equestricraft.mod.client.item.ProvisionTool;
import com.equestricraft.mod.packet.ClientBoundProvisionInventoryMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundProvisionItemListMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.NumberInputPrompt;
import com.equestricraft.mod.provision.ProvisionContainer;
import com.equestricraft.mod.provision.ProvisionInventoryPage;
import com.equestricraft.mod.provision.ProvisionInventoryPageSession;
import com.equestricraft.mod.provision.ProvisionService;
import com.equestricraft.mod.util.ComponentUtil;
import com.equestricraft.mod.util.ServerLevelUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ProvisionServiceImpl
implements ProvisionService {
    @Service
    private ProvisionInventoryPageSession provisionInventoryPageSession;
    @Service
    private ProvisionInventoryItemSession provisionInventoryItemSession;
    @Service
    private ProvisionRepository provisionRepository;
    @Service
    private HorseRepository horseRepository;

    @Override
    public Response giveProvisionToolToPlayer(OnlinePlayer player) {
        ProvisionTool item = ModItems.getProvisionTool();
        ItemStack tool = new ItemStack((ItemLike)item);
        tool.m_41714_((Component)ComponentUtil.buildColoredTextComponent("Provision Tool"));
        player.serverPlayer().m_150109_().m_36054_(tool);
        return ResponseFactory.success();
    }

    @Override
    public void showProvisionItemsMenuToPlayer(OnlinePlayer player, EQHorse horse) {
        List<ProvisionTypeInventoryDetails> items = this.provisionInventoryItemSession.retrieveListOfProvisionItemsPlayerHas(player);
        ClientBoundProvisionItemListMenuOpenPacket packet = new ClientBoundProvisionItemListMenuOpenPacket(horse.getId(), null, items);
        player.sendPacket(packet);
    }

    @Override
    public void showProvisionItemsMenuToPlayer(OnlinePlayer player, ProvisionContainer container) {
        List<ProvisionTypeInventoryDetails> items = this.provisionInventoryItemSession.retrieveListOfProvisionItemsPlayerHas(player);
        ClientBoundProvisionItemListMenuOpenPacket packet = new ClientBoundProvisionItemListMenuOpenPacket(null, container.m_142049_(), items);
        player.sendPacket(packet);
    }

    @Override
    public void showProvisionMenuToPlayer(ECPlayer player, Integer horseId, int provisionId, int pageNumber, Integer containerEntityId) {
        if (horseId != null) {
            EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
            this.showProvisionMenuToPlayer(player, horse, provisionId, pageNumber);
        } else {
            this.showProvisionMenuToPlayer(player, containerEntityId, provisionId, pageNumber);
        }
    }

    @Override
    public void showProvisionMenuToPlayer(ECPlayer player, EQHorse horse, int provisionId, int pageNumber) {
        ProvisionInventoryPage page = this.provisionInventoryPageSession.getProvisionPage(player, provisionId, pageNumber);
        Provision provision = (Provision)this.provisionRepository.findByKey(provisionId);
        ECLevel level = ServerLevelUtil.getEntitiesECLevel((Entity)player.require(OnlinePlayer.class).serverPlayer());
        ClientBoundProvisionInventoryMenuOpenPacket packet = new ClientBoundProvisionInventoryMenuOpenPacket(page, horse.getId(), provisionId, provision.getName(), null, level);
        player.sendPacket(packet);
    }

    @Override
    public void showProvisionMenuToPlayer(ECPlayer player, Integer containerEntityId, int provisionId, int pageNumber) {
        ProvisionInventoryPage page = this.provisionInventoryPageSession.getProvisionPage(player, provisionId, pageNumber);
        Provision provision = (Provision)this.provisionRepository.findByKey(provisionId);
        ECLevel level = ServerLevelUtil.getEntitiesECLevel((Entity)player.require(OnlinePlayer.class).serverPlayer());
        ClientBoundProvisionInventoryMenuOpenPacket packet = new ClientBoundProvisionInventoryMenuOpenPacket(page, null, provisionId, provision.getName(), containerEntityId, level);
        player.sendPacket(packet);
    }

    @Override
    public Response giveProvisionToHorse(OnlinePlayer player, UUID provisionUuid, int horseId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        Optional<Number> amount = NumberInputPrompt.showNumberInputPrompt(player, I18n.getLabel("horse.provision.give.title"), I18n.getLabel("horse.provision.give.enter-quantity"));
        if (amount.isPresent()) {
            try {
                boolean tookProvision = horse.getProvision().giveProvision(provisionUuid, player, amount.get().doubleValue());
                if (tookProvision) {
                    return ResponseFactory.success(I18n.getLabel("horse.provision.give.success"));
                }
                return ResponseFactory.fail(I18n.getLabel("horse.provision.give.fail"));
            }
            catch (ProvisionGiveException ex) {
                return ResponseFactory.fail(ex);
            }
        }
        return ResponseFactory.fail();
    }
}

