/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.quest;

import com.equestricraft.base.eventbus.ECEventBusListener;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.core.quest.QuestConversationActionResponseEvent;
import com.equestricraft.core.quest.QuestTrackStateUpdateEvent;
import com.equestricraft.core.quest.menu.QuestMenuItem;
import com.equestricraft.core.quest.menu.QuestMenuSession;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.core.quest.state.PlayerQuestData;
import com.equestricraft.core.quest.state.PlayerQuestState;
import com.equestricraft.core.quest.state.QuestPlayerStateSession;
import com.equestricraft.mod.movement.PlayerMoveEvent;
import com.equestricraft.mod.npc.NPCInteractEvent;
import com.equestricraft.mod.player.ECPlayerJoinEvent;
import com.equestricraft.mod.player.ECPlayerLeaveEvent;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.quest.QuestService;
import com.equestricraft.mod.util.BlockPosUtil;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public final class QuestListener {
    @Service
    private static QuestService questService;
    @Service
    private static QuestMenuSession questMenuSession;
    @Service
    private static QuestPlayerStateSession questPlayerStateSession;
    private static final OnlinePlayerCache onlinePlayerCache;

    @SubscribeEvent
    public static void onNpcInteract(NPCInteractEvent event) {
        QuestPlayer player = event.getOnlinePlayer().require(QuestPlayer.class);
        if (player.hasTrackedQuest()) {
            boolean processed = questService.onObjectiveNpcInteract(player, event.getNpc());
            if (processed) {
                event.setCanceled(true);
            }
        } else {
            List<QuestMenuItem> sections = questMenuSession.retrieveQuestMenuItemsForNpc(player, event.getNpc());
            if (!sections.isEmpty()) {
                event.addAction(I18n.getLabel("npc.action.quest"), () -> questService.noActiveQuestInteract(event.getOnlinePlayer(), event.getNpc().getId(), sections));
            }
        }
    }

    @SubscribeEvent
    public static void playerMove(PlayerMoveEvent event) {
        OnlinePlayer player = event.getPlayer();
        Coordinate coordinate = player.getCoordinate();
        QuestPlayer questPlayer = player.require(QuestPlayer.class);
        if (questPlayer.hasTrackedQuest()) {
            questService.onObjectivePlayerMove(questPlayer, coordinate);
        } else {
            questService.onStartingLocationReach(player, coordinate);
        }
    }

    @SubscribeEvent
    public static void onBlockInteract(PlayerInteractEvent event) {
        OnlinePlayer onlinePlayer = onlinePlayerCache.requirePlayer(event.getPlayer().m_142081_()).require(OnlinePlayer.class);
        BlockCoordinate blockCoordinate = BlockPosUtil.toBlockCoordinate(event.getPos(), onlinePlayer.getECLevel());
        QuestPlayer questPlayer = onlinePlayer.require(QuestPlayer.class);
        if (questPlayer.hasTrackedQuest()) {
            questService.onObjectiveBlockInteract(questPlayer, blockCoordinate);
        } else {
            questService.onStartingBlockInteract(onlinePlayer, blockCoordinate);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(ECPlayerJoinEvent event) {
        OnlinePlayer player = event.getPlayer();
        QuestPlayer questPlayer = new QuestPlayer(player.getCorePlayer());
        Optional<QuestPlayer> previous = player.provideData(questPlayer);
        previous.ifPresent(p -> p.getLifecycleManager().shutdown());
        PlayerQuestData data = questPlayerStateSession.loadQuestDataForPlayer(questPlayer);
        questPlayer.setPlayerQuestData(data);
        PlayerQuestState trackedQuest = data.getTrackedQuestState();
        if (trackedQuest != null) {
            questService.setTrackedQuest(player, trackedQuest.getQuest().getId());
        }
        questService.updateQuestInfoDisplay(questPlayer);
    }

    @SubscribeEvent
    public static void onPlayerLeave(ECPlayerLeaveEvent event) {
        ECPlayer player = event.getPlayer();
        questPlayerStateSession.persistQuestDataForPlayer(player);
    }

    @ECEventBusListener
    public static void onQuestTrackStateUpdateEvent(QuestTrackStateUpdateEvent event) {
        questService.updateQuestInfoDisplay(event.getPlayer());
    }

    @ECEventBusListener
    public static void onConversationResponse(QuestConversationActionResponseEvent event) {
        questService.processResponseForPlayer(event.getResponse(), event.getPlayer());
    }

    private QuestListener() {
    }

    static {
        onlinePlayerCache = OnlinePlayerCache.getInstance();
    }
}

