/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.quest;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.Argb;
import com.equestricraft.common.NotFoundException;
import com.equestricraft.common.QuestConversationPromptType;
import com.equestricraft.common.QuestType;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.config.APIConfigDtoImpl;
import com.equestricraft.core.global.APIGlobalDtoImpl;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.core.npc.NPCRepository;
import com.equestricraft.core.player.APIPlayerDtoImpl;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.core.quest.CannotPauseQuestException;
import com.equestricraft.core.quest.CannotStartQuestException;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestActionProcessSession;
import com.equestricraft.core.quest.QuestException;
import com.equestricraft.core.quest.QuestPlaySession;
import com.equestricraft.core.quest.QuestRepository;
import com.equestricraft.core.quest.QuestStartConditionSession;
import com.equestricraft.core.quest.QuestStartDetails;
import com.equestricraft.core.quest.QuestStartSession;
import com.equestricraft.core.quest.QuestStringInterpolator;
import com.equestricraft.core.quest.TrackedQuestDisplayInformation;
import com.equestricraft.core.quest.element.QuestConversationObjective;
import com.equestricraft.core.quest.element.QuestElement;
import com.equestricraft.core.quest.element.QuestObjective;
import com.equestricraft.core.quest.element.QuestStartElement;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionAutoAdvanceResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionDefaultResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionInvalidInputResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionObjectiveCompleteResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionPromptResponse;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionResponse;
import com.equestricraft.core.quest.element.lifecycle.QuestConversationObjectiveLifecycle;
import com.equestricraft.core.quest.element.lifecycle.QuestElementLifecycle;
import com.equestricraft.core.quest.element.lifecycle.QuestElementLifecycleStatus;
import com.equestricraft.core.quest.element.lifecycle.QuestObjectiveElementLifecycle;
import com.equestricraft.core.quest.menu.QuestInProgressMenuItem;
import com.equestricraft.core.quest.menu.QuestMenuItem;
import com.equestricraft.core.quest.menu.QuestMenuSession;
import com.equestricraft.core.quest.menu.QuestObjectiveMenuItem;
import com.equestricraft.core.quest.menu.QuestProgressMenuInfo;
import com.equestricraft.core.quest.progress.QuestProgressResetSession;
import com.equestricraft.core.quest.prompt.QuestAlertPrompt;
import com.equestricraft.core.quest.prompt.QuestChoicePrompt;
import com.equestricraft.core.quest.prompt.QuestPrompt;
import com.equestricraft.core.quest.prompt.QuestScriptPrompt;
import com.equestricraft.core.quest.prompt.QuestTextPrompt;
import com.equestricraft.core.quest.prompt.QuestYesNoPrompt;
import com.equestricraft.core.quest.questplayer.QuestPlayer;
import com.equestricraft.core.quest.state.ActiveQuestStopwatch;
import com.equestricraft.core.quest.state.ActiveQuestTimer;
import com.equestricraft.core.quest.state.PlayerQuestState;
import com.equestricraft.core.quest.storygroup.QuestStoryGroup;
import com.equestricraft.core.quest.storygroup.QuestStoryGroupRepository;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.GroovyPromptNeededException;
import com.equestricraft.groovy.executor.GroovyPromptScriptExecutor;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.groovy.prompt.GroovyPromptService;
import com.equestricraft.mod.packet.ClientBoundInProgressQuestsMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundQuestCurrentMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundQuestInfoDisplayUpdatePacket;
import com.equestricraft.mod.packet.ClientBoundQuestMainMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundQuestMenuItemListPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.OptionPromptItem;
import com.equestricraft.mod.prompt.SingleSelectionOptionPrompt;
import com.equestricraft.mod.prompt.TextInputPrompt;
import com.equestricraft.mod.quest.QuestService;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class QuestServiceImpl
implements QuestService {
    @Service
    private QuestPlaySession questPlaySession;
    @Service
    private QuestMenuSession questMenuSession;
    @Service
    private QuestStoryGroupRepository questStoryGroupRepository;
    @Service
    private QuestRepository questRepository;
    @Service
    private NPCRepository npcRepository;
    @Service
    private QuestActionProcessSession questActionProcessSession;
    @Service
    private QuestStartSession questStartSession;
    @Service
    private QuestProgressResetSession questProgressResetSession;
    @Service
    private QuestStartConditionSession questStartConditionSession;
    @Service
    private GroovyPromptService groovyPromptService;
    private static final Log log = Log.getLogger(QuestServiceImpl.class.getName());

    @Override
    public Response onQuests(OnlinePlayer player) {
        QuestPlayer questPlayer = player.require(QuestPlayer.class);
        if (questPlayer.hasTrackedQuest()) {
            this.showCurrentQuestMenu(questPlayer);
        } else {
            ClientBoundQuestMainMenuOpenPacket packet = new ClientBoundQuestMainMenuOpenPacket();
            player.sendPacket(packet);
        }
        return ResponseFactory.success();
    }

    private void showCurrentQuestMenu(QuestPlayer player) {
        PlayerQuestState state = player.getTrackedQuestState();
        Quest quest = state.getQuest();
        QuestProgressMenuInfo questInfo = new QuestProgressMenuInfo(quest.getId(), quest.getName(), quest.getNotYetPlayedDescription(), state.allowPause(), this.getObjectiveMenuItems(player, this.getObjectivesToShow(state.getElementLifecycles()).toList()));
        ClientBoundQuestCurrentMenuOpenPacket packet = new ClientBoundQuestCurrentMenuOpenPacket(questInfo);
        player.sendPacket(packet);
    }

    private <T extends QuestElement> Stream<QuestObjective> getObjectivesToShow(Stream<QuestElementLifecycle<T>> states) {
        return states.filter(Predicate.not(o -> o.getStatus() == QuestElementLifecycleStatus.NOT_ACTIVE)).map(QuestElementLifecycle::getElement).filter(QuestObjective.class::isInstance).map(QuestObjective.class::cast).filter(Predicate.not(QuestObjective::isSilent));
    }

    private List<QuestObjectiveMenuItem> getObjectiveMenuItems(QuestPlayer player, List<QuestObjective> objectives) {
        return objectives.stream().map(o -> this.buildObjectiveItem((QuestObjective)o, player)).sorted((o1, o2) -> Boolean.compare(o1.completed(), o2.completed())).toList();
    }

    private QuestObjectiveMenuItem buildObjectiveItem(QuestObjective objective, QuestPlayer player) {
        boolean completed = player.getTrackedQuestState().isElementCompleted(objective);
        QuestElementLifecycle lifecycle = objective.getLifecycle(player);
        QuestStringInterpolator interpolator = new QuestStringInterpolator(player, (QuestObjectiveElementLifecycle<?>)lifecycle);
        String objectiveName = interpolator.execute(lifecycle.getName());
        String objectiveHint = interpolator.execute(((QuestObjectiveElementLifecycle)lifecycle).getHint());
        return new QuestObjectiveMenuItem(objective.getId(), objectiveName, objectiveHint, completed);
    }

    @Override
    public void onStartingLocationReach(ECPlayer player, Coordinate coordinate) {
        Optional<QuestStartDetails> startResponse = this.questStartConditionSession.findQuestWithStartingLocation(player, coordinate);
        if (startResponse.isPresent()) {
            try {
                QuestPlayer questPlayer = player.require(QuestPlayer.class);
                this.questStartSession.startQuest(questPlayer, startResponse.get().quest(), startResponse.get().startingElement());
            }
            catch (CannotStartQuestException cannotStartQuestException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onStartingBlockInteract(ECPlayer player, BlockCoordinate blockCoordinate) {
        List<QuestStartDetails> quests = this.questStartConditionSession.findQuestsForBlockCoordinate(player, blockCoordinate).toList();
        if (quests.isEmpty()) {
            return;
        }
        if (quests.size() == 1) {
            QuestStartDetails starter = quests.get(0);
            TaskScheduler.executeAsyncTask(() -> this.startQuest(player, starter.quest(), starter.startingElement()));
        } else {
            QuestPlayer questPlayer = player.require(QuestPlayer.class);
            List<QuestMenuItem> menuSections = this.questMenuSession.retrieveQuestMenuItemsForBlockInteract(questPlayer, blockCoordinate);
            ClientBoundQuestMenuItemListPacket packet = new ClientBoundQuestMenuItemListPacket(I18n.getLabel(QuestType.STANDARD.getMenuTitleKey()), QuestType.STANDARD, menuSections);
            player.sendPacket(packet);
        }
    }

    @Override
    public void showInProgressQuestsMenu(OnlinePlayer player) {
        QuestPlayer questPlayer = player.require(QuestPlayer.class);
        List<QuestInProgressMenuItem> inProgressQuests = this.questMenuSession.retrieveInProgressQuestMenuItemsForPlayer(questPlayer);
        ClientBoundInProgressQuestsMenuOpenPacket packet = new ClientBoundInProgressQuestsMenuOpenPacket(inProgressQuests);
        player.sendPacket(packet);
    }

    @Override
    public void showAvailableQuestsMenu(OnlinePlayer player, QuestType questType) {
        QuestPlayer questPlayer = player.require(QuestPlayer.class);
        List<QuestMenuItem> menuSections = this.questMenuSession.retrieveQuestMenuSections(questPlayer, questType);
        ClientBoundQuestMenuItemListPacket packet = new ClientBoundQuestMenuItemListPacket(I18n.getLabel(questType.getMenuTitleKey()), questType, menuSections);
        player.sendPacket(packet);
    }

    @Override
    public void showMenuForGroup(OnlinePlayer player, int groupId, QuestType questType) {
        QuestPlayer questPlayer = player.require(QuestPlayer.class);
        List<QuestMenuItem> sections = this.questMenuSession.retrieveQuestMenuSections(questPlayer, questType, groupId);
        QuestStoryGroup group = (QuestStoryGroup)this.questStoryGroupRepository.findByKey(groupId);
        ClientBoundQuestMenuItemListPacket packet = new ClientBoundQuestMenuItemListPacket(group.getName(), questType, sections);
        player.sendPacket(packet);
    }

    @Override
    public void startQuest(ECPlayer player, int questId, UUID startElementId) {
        Quest quest = (Quest)this.questRepository.findByKeyIfExists(questId).orElseThrow(() -> new NotFoundException(String.format("Could not find quest with ID %s", questId)));
        log.info("Starting quest {} for {}", (Object)quest, (Object)player);
        QuestStartElement startElement = (QuestStartElement)quest.getElementById(startElementId);
        this.startQuest(player, quest, startElement);
        log.info("Started quest {} for {}", (Object)quest, (Object)player);
    }

    private void startQuest(ECPlayer player, Quest quest, QuestStartElement startElement) {
        try {
            QuestPlayer questPlayer = player.require(QuestPlayer.class);
            if (!quest.getAskMessage().isBlank()) {
                ConfirmResponse response = player.getConfirmation().confirm(quest.getName(), quest.getAskMessage());
                if (response.isYes()) {
                    this.questStartSession.startQuest(questPlayer, quest, startElement);
                }
            } else {
                this.questStartSession.startQuest(questPlayer, quest, startElement);
            }
        }
        catch (CannotStartQuestException ex) {
            player.getAlert().error(ex.getTitle(), ex.getMessage());
        }
    }

    @Override
    public Response setTrackedQuest(OnlinePlayer player, int questId) {
        QuestPlayer questPlayer = player.require(QuestPlayer.class);
        this.questPlaySession.setTrackedQuest(questPlayer, questId);
        return ResponseFactory.success(I18n.getLabel("quest.set-tracked.set-active-response"));
    }

    @Override
    public Response pauseTrackedQuest(OnlinePlayer player) {
        QuestPlayer questPlayer = player.require(QuestPlayer.class);
        if (!questPlayer.getTrackedQuestState().allowPause()) {
            return ResponseFactory.fail(I18n.getLabel("quest.pause.fail.prompt.title"), I18n.getLabel("quest.cannot-pause"));
        }
        ConfirmResponse response = player.getConfirmation().confirm(I18n.getLabel("quest.pause-quest.prompt.title"), I18n.getLabel("quest.pause-quest.prompt.message"));
        if (response.isYes()) {
            try {
                this.questPlaySession.pauseTrackedQuest(questPlayer);
                return ResponseFactory.success(I18n.getLabel("quest.paused.paused-response"));
            }
            catch (CannotPauseQuestException ex) {
                return ResponseFactory.fail(I18n.getLabel("quest.pause.fail.prompt.title"), ex);
            }
        }
        return this.onQuests(player);
    }

    @Override
    public Response abandonTrackedQuest(OnlinePlayer player) {
        QuestPlayer questPlayer = player.require(QuestPlayer.class);
        if (!questPlayer.hasTrackedQuest()) {
            return ResponseFactory.fail(I18n.getLabel("quest.abandon.no-active-quest"));
        }
        ConfirmResponse response = player.getConfirmation().confirm(I18n.getLabel("quest.abandon-quest.prompt.title"), I18n.getLabel("quest.abandon-quest.prompt.message"));
        if (response.isYes()) {
            this.questPlaySession.abandonTrackedQuest(questPlayer);
            return ResponseFactory.success(I18n.getLabel("quest.abandon.abandoned-response"));
        }
        return this.onQuests(player);
    }

    @Override
    public Response resetQuestProgress(OnlinePlayer player) {
        ConfirmResponse response = player.getConfirmation().confirm(I18n.getLabel("quest.reset-progress.prompt.title"), I18n.getLabel("quest.reset-progress.prompt.message"));
        if (response.isYes()) {
            this.questProgressResetSession.resetQuestProgressForPlayer(player);
            return ResponseFactory.success(I18n.getLabel("quest.reset-progress.success.title"), I18n.getLabel("quest.reset-progress.success.message"));
        }
        return ResponseFactory.fail();
    }

    @Override
    public boolean onObjectiveNpcInteract(QuestPlayer player, NPC npc) {
        return this.doNpcInteract(player, npc, null);
    }

    private boolean doNpcInteract(QuestPlayer player, NPC npc, Object promptInput) {
        Optional<QuestConversationActionResponse> response = this.questActionProcessSession.processNPCTalk(player, npc, promptInput);
        if (response.isPresent()) {
            this.processResponseForPlayer(response.get(), player);
            return true;
        }
        return false;
    }

    @Override
    public boolean processResponseForPlayer(QuestConversationActionResponse response, QuestPlayer player) {
        try {
            return this.processResponse(response, player).map(o -> this.doNpcInteract(player, response.getObjective().getNpc(), o)).orElse(false);
        }
        catch (QuestException ex) {
            this.questPlaySession.abortTrackedQuestWithError(player, ex.getMessage());
            return false;
        }
    }

    private Optional<Object> processResponse(QuestConversationActionResponse response, QuestPlayer player) {
        if (response instanceof QuestConversationActionPromptResponse) {
            QuestConversationActionPromptResponse questConversationActionPromptResponse = (QuestConversationActionPromptResponse)response;
            OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
            Object input = this.processPrompt(onlinePlayer, questConversationActionPromptResponse.getPrompt());
            return Optional.ofNullable(input);
        }
        if (response instanceof QuestConversationActionObjectiveCompleteResponse) {
            QuestConversationActionObjectiveCompleteResponse questConversationActionObjectiveCompleteResponse = (QuestConversationActionObjectiveCompleteResponse)response;
            QuestConversationObjectiveLifecycle elementLifecycle = questConversationActionObjectiveCompleteResponse.getObjective().getLifecycle(player);
            elementLifecycle.activateOutput(questConversationActionObjectiveCompleteResponse.getOutput());
            return Optional.empty();
        }
        if (response instanceof QuestConversationActionInvalidInputResponse) {
            QuestConversationActionInvalidInputResponse questConversationActionInvalidInputResponse = (QuestConversationActionInvalidInputResponse)response;
            player.getAlert().error(questConversationActionInvalidInputResponse.getTitle(), questConversationActionInvalidInputResponse.getMessage());
            return Optional.empty();
        }
        if (response instanceof QuestConversationActionAutoAdvanceResponse) {
            QuestConversationActionAutoAdvanceResponse questConversationActionAutoAdvanceResponse = (QuestConversationActionAutoAdvanceResponse)response;
            questConversationActionAutoAdvanceResponse.getFuture().thenAccept(v -> this.doNextElement(player, response.getObjective()));
            return Optional.empty();
        }
        if (response instanceof QuestConversationActionDefaultResponse) {
            return Optional.empty();
        }
        throw new IllegalArgumentException(String.format("Invalid conversation process response type: %s", response.getClass().getName()));
    }

    private void doNextElement(QuestPlayer player, QuestConversationObjective objective) {
        TaskScheduler.executeAsyncTask(() -> this.doNpcInteract(player, objective.getNpc(), Collections.emptyMap()));
    }

    private Object processPrompt(OnlinePlayer player, QuestPrompt questPrompt) {
        return switch (questPrompt.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case QuestConversationPromptType.TEXT -> this.processTextPrompt(player, (QuestTextPrompt)questPrompt);
            case QuestConversationPromptType.ALERT -> this.processAlertPrompt(player, (QuestAlertPrompt)questPrompt);
            case QuestConversationPromptType.CHOICE -> this.processChoicePrompt(player, (QuestChoicePrompt)questPrompt);
            case QuestConversationPromptType.YES_NO -> this.processYesNoPrompt(player, (QuestYesNoPrompt)questPrompt);
            case QuestConversationPromptType.SCRIPT -> this.processScriptPrompt(player, (QuestScriptPrompt)questPrompt);
        };
    }

    private Object processTextPrompt(ECPlayer player, QuestTextPrompt questTextPrompt) {
        Optional<String> response = TextInputPrompt.showTextInputPrompt(player, questTextPrompt.getTitle(), questTextPrompt.getText());
        return response.orElse(null);
    }

    private Object processAlertPrompt(ECPlayer player, QuestAlertPrompt questAlertPrompt) {
        return player.getAlert().alert(questAlertPrompt.getTitle(), questAlertPrompt.getText());
    }

    private Object processChoicePrompt(ECPlayer player, QuestChoicePrompt questChoicePrompt) {
        Optional<QuestChoicePrompt.Choice> response = SingleSelectionOptionPrompt.showOptionPrompt(player, questChoicePrompt.getChoices(), this::buildOptionItem, questChoicePrompt.getTitle(), questChoicePrompt.getText());
        return response.map(QuestChoicePrompt.Choice::id).orElse(null);
    }

    private OptionPromptItem<QuestChoicePrompt.Choice> buildOptionItem(final QuestChoicePrompt.Choice choice) {
        return new OptionPromptItem<QuestChoicePrompt.Choice>(){

            @Override
            public int getId() {
                return choice.id();
            }

            @Override
            public String getName() {
                return choice.text();
            }

            @Override
            public QuestChoicePrompt.Choice getItem() {
                return choice;
            }
        };
    }

    private Object processYesNoPrompt(ECPlayer player, QuestYesNoPrompt questYesNoPrompt) {
        ConfirmResponse response = player.getConfirmation().confirm(questYesNoPrompt.getTitle(), questYesNoPrompt.getText());
        if (response.isYes()) {
            return true;
        }
        if (response.isNo()) {
            return false;
        }
        return null;
    }

    private Object processScriptPrompt(ECPlayer player, QuestScriptPrompt questScriptPrompt) {
        QuestPlayer questPlayer = player.require(QuestPlayer.class);
        try {
            ((GroovyPromptScriptExecutor)((GroovyPromptScriptExecutor)((GroovyPromptScriptExecutor)((GroovyPromptScriptExecutor)GroovyPromptScriptExecutor.start(questScriptPrompt.getScript()).withPlayer(new APIPlayerDtoImpl(player.getCorePlayer()))).withGlobal(new APIGlobalDtoImpl())).withConfig(new APIConfigDtoImpl())).withSessionData(questPlayer.getTrackedQuestState().getGroovyScriptSessionData())).execute();
            return true;
        }
        catch (GroovyPromptNeededException ex) {
            this.groovyPromptService.processPromptRequests(player, ex.getRequest());
            return true;
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing prompt script %s", questScriptPrompt.getTitle()), ex);
            return false;
        }
    }

    @Override
    public void noActiveQuestInteract(OnlinePlayer player, int npcId, List<QuestMenuItem> quests) {
        NPC npc = (NPC)this.npcRepository.findByKey(npcId);
        ClientBoundQuestMenuItemListPacket packet = new ClientBoundQuestMenuItemListPacket(npc.getName(), QuestType.STANDARD, quests);
        player.sendPacket(packet);
    }

    @Override
    public void onObjectivePlayerMove(QuestPlayer player, Coordinate coordinate) {
        this.questActionProcessSession.processLocationChange(player, coordinate);
    }

    @Override
    public void onObjectiveBlockInteract(QuestPlayer player, BlockCoordinate blockCoordinate) {
        this.questActionProcessSession.processBlockInteract(player, blockCoordinate);
    }

    @Override
    public void updateQuestInfoDisplay(QuestPlayer player) {
        TrackedQuestDisplayInformation trackedQuestDisplayInformation = null;
        if (player.hasTrackedQuest()) {
            PlayerQuestState state = player.getTrackedQuestState();
            String questName = state.getQuest().getName();
            List<String> objectives = this.getObjectivesToShow(state.getActiveElementLifecycles()).map(o -> o.getLifecycle(player)).map(o -> new QuestStringInterpolator(player, (QuestObjectiveElementLifecycle<?>)o).execute(o.getName())).toList();
            Optional<ActiveQuestTimer> activeTimer = player.getActiveNonSilentTimer();
            Date timerEndTime = null;
            Argb timerEndColor = null;
            if (activeTimer.isPresent()) {
                timerEndTime = activeTimer.get().getEndTime();
                timerEndColor = activeTimer.get().getEndColor();
            }
            Date stopwatchStartTime = player.getActiveNonSilentStopwatch().map(ActiveQuestStopwatch::getStartTime).orElse(null);
            trackedQuestDisplayInformation = new TrackedQuestDisplayInformation(questName, objectives, new Date(), timerEndTime, timerEndColor, stopwatchStartTime);
        }
        ClientBoundQuestInfoDisplayUpdatePacket packet = new ClientBoundQuestInfoDisplayUpdatePacket(trackedQuestDisplayInformation);
        player.sendPacket(packet);
    }
}

