/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.quest;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.QuestPlayersResponseMessage;
import com.equestricraft.core.quest.QuestLoadService;
import com.equestricraft.core.quest.QuestPlayersCache;
import com.equestricraft.core.quest.element.conversation.QuestConversationActionProcessQueue;
import com.equestricraft.core.system.SubSystem;
import com.equestricraft.mod.quest.QuestService;
import com.equestricraft.redis.RedisChannelSubscription;
import com.equestricraft.redis.RedisRequestReceiver;
import java.util.List;

public class QuestSystem
implements SubSystem {
    @Service
    private QuestLoadService questLoadService;
    @Service
    private QuestService questService;
    private final RedisRequestReceiver<Integer, QuestPlayersResponseMessage> questPlayersRedisRequestReceiver = new RedisRequestReceiver("quest_players");
    private final QuestConversationActionProcessQueue questConversationActionProcessQueue = QuestConversationActionProcessQueue.getInstance();
    private final QuestPlayersCache questPlayersCache = QuestPlayersCache.getInstance();
    private final RedisChannelSubscription<Integer> questRewardChannel = new RedisChannelSubscription("quest-reward-update");

    @Override
    public void onLoad() {
        this.questLoadService.loadQuests();
        this.questLoadService.loadData();
    }

    @Override
    public void onEnable() {
        this.questConversationActionProcessQueue.consumeActions(entry -> this.questService.processResponseForPlayer(entry.actionResponse(), entry.player()));
        this.questPlayersRedisRequestReceiver.registerListener(this::handleQuestPlayerRequest);
        this.questRewardChannel.subscribe(this.questLoadService::loadRewardUpdate);
    }

    private QuestPlayersResponseMessage handleQuestPlayerRequest(int questId) {
        List<Integer> players = this.questPlayersCache.getPlayersPlayingQuest(questId);
        return new QuestPlayersResponseMessage(players);
    }

    @Override
    public void onDisable() {
        this.questConversationActionProcessQueue.shutdown();
    }
}

