/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.registration;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.registrationorganization.HorseRegistrationOrganization;
import com.equestricraft.core.registrationorganization.HorseRegistrationOrganizationRepository;
import com.equestricraft.mod.npc.NPCInteractEvent;
import com.equestricraft.mod.registration.HorseRegistrationService;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class HorseRegistrationListener {
    @Service
    private static HorseRegistrationService horseRegistrationService;
    @Service
    private static HorseRegistrationOrganizationRepository horseRegistrationOrganizationRepository;

    @SubscribeEvent
    public static void onNpcInteract(NPCInteractEvent event) {
        List<HorseRegistrationOrganization> organizations = horseRegistrationOrganizationRepository.findByNpcId(event.getNpc().getId());
        for (HorseRegistrationOrganization organization : organizations) {
            event.addAction(organization.getName(), () -> {
                Response r = horseRegistrationService.showRegistrationOrganizationMenu(event.getOnlinePlayer(), organization);
                event.getOnlinePlayer().showResponse(r);
            });
        }
    }

    private HorseRegistrationListener() {
    }
}

