/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.registration;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.StringUtils;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.registration.HorseRegistrationException;
import com.equestricraft.core.horse.registration.HorseRegistrationInfo;
import com.equestricraft.core.horse.registration.HorseRegistrationResponse;
import com.equestricraft.core.horse.registration.HorseRegistrationSession;
import com.equestricraft.core.namegenerator.NameGeneratorSession;
import com.equestricraft.core.player.PlayerTransformer;
import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.core.registrationorganization.HorseRegistrationOrganization;
import com.equestricraft.core.registrationorganization.HorseRegistrationOrganizationRepository;
import com.equestricraft.core.registrationorganization.HorseRegistrationOrganizationSimple;
import com.equestricraft.core.registrationorganization.HorseRegistrationOrganizationTransformer;
import com.equestricraft.mod.packet.ClientBoundHorseRegistrationOrganizationMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundSetShowNameOnRegistrationPacket;
import com.equestricraft.mod.packet.ClientBoundShowHorseRegistrationPromptPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.LoadingPrompt;
import com.equestricraft.mod.registration.HorseRegistrationOrganizationInfo;
import com.equestricraft.mod.registration.HorseRegistrationService;
import java.util.Optional;

public class HorseRegistrationServiceImpl
implements HorseRegistrationService {
    @Service
    private HorseRegistrationSession horseRegistrationSession;
    @Service
    private HorseRegistrationOrganizationRepository horseRegistrationOrganizationRepository;
    @Service
    private NameGeneratorSession nameGeneratorSession;
    @Service
    private HorseRepository horseRepository;
    @Service
    private PlayerTransformer playerTransformer;
    @Service
    private HorseRegistrationOrganizationTransformer horseRegistrationOrganizationTransformer;

    @Override
    public Response showRegistrationOrganizationMenu(OnlinePlayer player, HorseRegistrationOrganization organization) {
        HorseRegistrationOrganizationInfo info2;
        EQHorse horse = player.getHorses().requiredSelected();
        Optional<HorseRegistrationInfo> registrationForHorse = this.horseRegistrationSession.getHorsesRegistrationInfo(horse);
        HorseRegistrationOrganizationSimple organizationSimple = this.horseRegistrationOrganizationTransformer.toSimple(organization);
        if (registrationForHorse.isPresent() && registrationForHorse.get().organization().id() == organization.getId()) {
            HorseRegistrationInfo registration = registrationForHorse.get();
            info2 = new HorseRegistrationOrganizationInfo(organizationSimple, registration.horse().getId(), registration.registrationNumber(), registration.showName(), this.playerTransformer.toSimple(registration.registeringPlayer().getCorePlayer()), registration.registrationDate());
        } else {
            info2 = new HorseRegistrationOrganizationInfo(organizationSimple, horse.getId(), null, null, null, null);
        }
        ClientBoundHorseRegistrationOrganizationMenuOpenPacket packet = new ClientBoundHorseRegistrationOrganizationMenuOpenPacket(info2);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public Response showRegisterPrompt(OnlinePlayer player, int horseId, int organizationId) {
        HorseRegistrationOrganization organization = (HorseRegistrationOrganization)this.horseRegistrationOrganizationRepository.findByKey(organizationId);
        HorseRegistrationOrganizationSimple simple = this.horseRegistrationOrganizationTransformer.toSimple(organization);
        ClientBoundShowHorseRegistrationPromptPacket packet = new ClientBoundShowHorseRegistrationPromptPacket(horseId, simple);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public Response requestRandomShowName(OnlinePlayer player) {
        String randomName = this.nameGeneratorSession.getRandomName(2);
        ClientBoundSetShowNameOnRegistrationPacket packet = new ClientBoundSetShowNameOnRegistrationPacket(randomName);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public Response registerHorse(OnlinePlayer player, int horseId, int organizationId, String showName) {
        HorseRegistrationOrganization organization = (HorseRegistrationOrganization)this.horseRegistrationOrganizationRepository.findByKey(organizationId);
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        showName = StringUtils.removeExtraSpaces(showName);
        ConfirmResponse confirmation = player.getConfirmation().confirm(organization.getName(), I18n.getLabel("horse.registration-office.confirm.message", horse.getName(), organization.getName(), this.horseRegistrationSession.getPossibleShowName(showName), EconomyUtilities.formatCurrency(organization.getPrice())));
        if (confirmation.isYes()) {
            if (horse.getOwnerId() != player.getId()) {
                return ResponseFactory.fail(organization.getName(), I18n.getLabel("horse.registration-office.only-owner-can-register.message"));
            }
            LoadingPrompt.showLoadingPrompt(player, I18n.getLabel("horse.registration-office.registering"));
            try {
                HorseRegistrationResponse response = this.horseRegistrationSession.registerHorseWithOrganization(horse, organizationId, showName);
                return ResponseFactory.success(organization.getName(), I18n.getLabel("horse.registration-office.success.message", response.registrationNumber(), response.showName()));
            }
            catch (EconomyException ex) {
                return ResponseFactory.fail(organization.getName(), ex);
            }
            catch (HorseRegistrationException ex) {
                return ResponseFactory.fail(ex.getTitle() != null ? ex.getTitle() : organization.getName(), ex.getMessage());
            }
        }
        return ResponseFactory.fail();
    }
}

