/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.response;

import com.equestricraft.base.response.BasicResponse;
import com.equestricraft.base.response.ComplexResponse;
import com.equestricraft.base.response.FutureResponse;
import com.equestricraft.base.response.PromptResponse;
import com.equestricraft.base.response.Response;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.ObjectUtils;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.response.ResponseHandler;
import com.equestricraft.mod.prompt.MessagePrompt;

public class ModResponseHandler
extends ResponseHandler {
    @Override
    protected void handleResponseImpl(ECPlayer player, Response response) {
        if (response instanceof BasicResponse) {
            BasicResponse basicResponse = (BasicResponse)response;
            player.notify(basicResponse.getMessage());
        } else if (response instanceof ComplexResponse) {
            ComplexResponse complexResponse = (ComplexResponse)response;
            for (String message : complexResponse.getMessages()) {
                player.sendMessage(message);
            }
        } else if (response instanceof PromptResponse) {
            PromptResponse promptResponse = (PromptResponse)response;
            if (response.isSuccess()) {
                MessagePrompt.showInfoPrompt(player, promptResponse.getTitle(), promptResponse.getMessage(), promptResponse.getOnOk());
            } else {
                String title = ObjectUtils.nullable(promptResponse.getTitle(), I18n.supplyLabel("common.error"));
                MessagePrompt.showErrorPrompt(player, title, promptResponse.getMessage(), promptResponse.getOnOk());
            }
        } else if (response instanceof FutureResponse) {
            FutureResponse futureResponse = (FutureResponse)response;
            futureResponse.getFuture().thenAcceptAsync(r -> this.handleResponseImpl(player, (Response)r));
        }
    }
}

