/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.salesbarn;

import com.equestricraft.common.ECLevel;
import com.equestricraft.core.salesbarn.stall.SalesBarnStall;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.world.level.ChunkPos;

public class SalesBarnChunkCache {
    private static final SalesBarnChunkCache instance = new SalesBarnChunkCache();
    private final Map<ECLevel, Map<ChunkPos, List<SalesBarnStall>>> dimensionChunkMap = new EnumMap<ECLevel, Map<ChunkPos, List<SalesBarnStall>>>(ECLevel.class);
    private final StampedLock lock = new StampedLock();

    public static SalesBarnChunkCache getInstance() {
        return instance;
    }

    private SalesBarnChunkCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMap(Map<ECLevel, Map<ChunkPos, List<SalesBarnStall>>> map) {
        long stamp = this.lock.writeLock();
        try {
            this.dimensionChunkMap.clear();
            this.dimensionChunkMap.putAll(map);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SalesBarnStall> getSalesBarnStallsInChunk(ECLevel level, ChunkPos chunkPos) {
        long stamp = this.lock.readLock();
        try {
            Map dimensionMap = this.dimensionChunkMap.getOrDefault((Object)level, Collections.emptyMap());
            List<SalesBarnStall> list = dimensionMap.getOrDefault(chunkPos, Collections.emptyList());
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }
}

