/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.salesbarn;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.ECLevel;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.horse.HorseEntityType;
import com.equestricraft.mod.salesbarn.SalesBarnHorseInteractEvent;
import com.equestricraft.mod.salesbarn.SalesBarnService;
import com.equestricraft.mod.util.ServerLevelUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class SalesBarnListener {
    @Service
    private static SalesBarnService salesBarnService;

    @SubscribeEvent
    public static void onChunkLoad(ChunkWatchEvent.Watch event) {
        ECLevel ecLevel = ServerLevelUtil.getECLevel((Level)event.getWorld());
        salesBarnService.spawnSalesBarnHorsesInChunk(ecLevel, event.getPos());
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        ServerLevel serverLevel = (ServerLevel)event.getWorld().m_7726_().m_7653_();
        for (Entity entity : serverLevel.m_143280_(EntityTypeTest.m_156916_(EntityHorse.class), e -> e.m_146902_().equals((Object)event.getChunk().m_7697_()) && e.getHorseEntityType() == HorseEntityType.SALES_BARN)) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @SubscribeEvent
    public static void onInteract(SalesBarnHorseInteractEvent event) {
        salesBarnService.showMenuForSalesBarnHorse(event.getPlayer(), event.getStall());
    }

    private SalesBarnListener() {
    }
}

