/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.salesbarn;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.ECLevel;
import com.equestricraft.common.HorseGaitVariant;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.config.APIConfigDtoImpl;
import com.equestricraft.core.global.APIGlobalDtoImpl;
import com.equestricraft.core.horse.gait.Walk;
import com.equestricraft.core.horse.texture.HorseTextureDetails;
import com.equestricraft.core.player.APIPlayerDtoImpl;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.core.salesbarn.SalesBarnHorseInfo;
import com.equestricraft.core.salesbarn.SalesBarnPurchaseException;
import com.equestricraft.core.salesbarn.SalesBarnPurchaseResponse;
import com.equestricraft.core.salesbarn.SalesBarnSession;
import com.equestricraft.core.salesbarn.group.SalesBarnStallGroup;
import com.equestricraft.core.salesbarn.group.SalesBarnStallGroupRepository;
import com.equestricraft.core.salesbarn.stall.SalesBarnStall;
import com.equestricraft.core.salesbarn.stall.SalesBarnStallRepository;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyRuleScriptExecutor;
import com.equestricraft.groovy.executor.GroovyScriptResponse;
import com.equestricraft.groovy.executor.RuleScriptResponse;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.horse.HorseEntityType;
import com.equestricraft.mod.horse.entity.GroundTractionPercentage;
import com.equestricraft.mod.horse.entity.HorseEntitySession;
import com.equestricraft.mod.horse.entity.HorseSpawnData;
import com.equestricraft.mod.horse.entity.StandardHorseEntitySession;
import com.equestricraft.mod.packet.ClientBoundSalesBarnHorseMenuPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.TextInputPrompt;
import com.equestricraft.mod.salesbarn.SalesBarnChunkCache;
import com.equestricraft.mod.salesbarn.SalesBarnService;
import com.equestricraft.mod.salesbarn.SpawnedSalesBarnStallCache;
import com.equestricraft.mod.salesbarn.StallLockHandler;
import com.equestricraft.mod.util.ChunkPosUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;

public class SalesBarnServiceImpl
implements SalesBarnService {
    @Service
    private SalesBarnStallRepository salesBarnStallRepository;
    @Service
    private SalesBarnStallGroupRepository salesBarnStallGroupRepository;
    @Service
    private SalesBarnSession salesBarnSession;
    @Service
    private HorseEntitySession horseEntitySession;
    @Service
    private StandardHorseEntitySession standardHorseEntitySession;
    private final SpawnedSalesBarnStallCache spawnedSalesBarnStallCache = SpawnedSalesBarnStallCache.getInstance();
    private final SalesBarnChunkCache salesBarnChunkCache = SalesBarnChunkCache.getInstance();
    private final StallLockHandler stallLockHandler = StallLockHandler.getInstance();
    private static final Log log = Log.getLogger(SalesBarnServiceImpl.class.getName());

    @Override
    public void spawnSalesBarnHorsesInChunk(ECLevel level, ChunkPos chunkPos) {
        List<SalesBarnStall> stallsInChunk = this.salesBarnChunkCache.getSalesBarnStallsInChunk(level, chunkPos);
        for (SalesBarnStall stall : stallsInChunk) {
            if (this.isStallLoadedInWorld(stall)) continue;
            TaskScheduler.executeAsyncTask(() -> this.spawnHorseInStall(stall));
        }
    }

    private boolean isStallLoadedInWorld(SalesBarnStall stall) {
        EntityHorse horse = this.spawnedSalesBarnStallCache.get(stall.getId());
        return horse != null && !horse.m_146910_();
    }

    private void spawnHorseInStall(SalesBarnStall stall) {
        HorseSpawnData data = new HorseSpawnData(this.determineTextureForHorse(stall), 0.0f, 0.0f, Walk.WORKING, HorseGaitVariant.STANDARD, GroundTractionPercentage.getDefault());
        this.horseEntitySession.spawnHorse(stall.getId(), HorseEntityType.SALES_BARN, stall.getDirectionalCoordinate(), data, null);
    }

    private HorseTextureDetails determineTextureForHorse(SalesBarnStall stall) {
        return HorseTextureDetails.withName(stall.getColor().getTextureFile().toLowerCase(), Collections.singletonList(stall.getMarking().name().toLowerCase()), "");
    }

    @Override
    public void showMenuForSalesBarnHorse(ECPlayer player, SalesBarnStall stall) {
        SalesBarnStallGroup group = (SalesBarnStallGroup)this.salesBarnStallGroupRepository.findByKey(stall.getGroupId());
        if (!this.canPlayerAccess(player, group)) {
            return;
        }
        SalesBarnHorseInfo horseInfo = this.salesBarnSession.retrieveInfoForHorseInStall(stall);
        Optional<Long> expiryTime = this.stallLockHandler.tryLockStallForPlayer(stall.getId(), player);
        if (expiryTime.isPresent()) {
            ClientBoundSalesBarnHorseMenuPacket packet = new ClientBoundSalesBarnHorseMenuPacket(horseInfo, expiryTime.get());
            player.sendPacket(packet);
        } else {
            player.getAlert().alert(I18n.getLabel("sales-barn.dialog.title"), I18n.getLabel("sales-barn.another-player-viewing"));
        }
    }

    private boolean canPlayerAccess(ECPlayer player, SalesBarnStallGroup group) {
        if (group.getAccessScript().isBlank()) {
            return true;
        }
        try {
            GroovyScriptResponse<RuleScriptResponse> response = ((GroovyRuleScriptExecutor)((GroovyRuleScriptExecutor)((GroovyRuleScriptExecutor)GroovyRuleScriptExecutor.start(group.getAccessScript()).withPlayer(new APIPlayerDtoImpl(player.getCorePlayer()))).withGlobal(new APIGlobalDtoImpl())).withConfig(new APIConfigDtoImpl())).execute();
            return response.result().success();
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing access script for group %s", group.getName()), ex);
            return false;
        }
    }

    @Override
    public Response purchaseHorse(OnlinePlayer onlinePlayer, int stallId) {
        if (!this.stallLockHandler.isStallLockedForPlayer(stallId, onlinePlayer)) {
            return ResponseFactory.fail(I18n.getLabel("sales-barn.dialog.title"), I18n.getLabel("sales-barn.purchase-time-expired"));
        }
        this.stallLockHandler.unlockStall(stallId, onlinePlayer);
        Optional<String> name = TextInputPrompt.showTextInputPrompt(onlinePlayer, I18n.getLabel("sales-barn.purchase.dialog.title"), I18n.getLabel("sales-barn.purchase.dialog.name.text"));
        if (name.isPresent()) {
            SalesBarnHorseInfo info2 = this.salesBarnSession.retrieveInfoForHorseInStall(stallId);
            ConfirmResponse confirmResponse = onlinePlayer.getConfirmation().confirm(I18n.getLabel("sales-barn.purchase.dialog.title"), I18n.getLabel("sales-barn.purchase.dialog.confirm.text", info2.price(), name.get()));
            if (confirmResponse.isYes()) {
                try {
                    SalesBarnPurchaseResponse response = this.salesBarnSession.purchaseHorse(onlinePlayer, stallId, name.get());
                    this.refreshStall(stallId);
                    this.standardHorseEntitySession.spawnHorse(response.horse(), (Entity)onlinePlayer.serverPlayer());
                    return ResponseFactory.success(I18n.getLabel("sales-barn.purchase.success", response.price(), response.newBalance()));
                }
                catch (SalesBarnPurchaseException ex) {
                    return ResponseFactory.fail(I18n.getLabel("sales-barn.purchase.success.prompt.title"), ex);
                }
            }
        }
        return ResponseFactory.fail();
    }

    private void refreshStall(int stallId) {
        EntityHorse horse = this.spawnedSalesBarnStallCache.get(stallId);
        horse.m_142687_(Entity.RemovalReason.DISCARDED);
        SalesBarnStall stall = (SalesBarnStall)this.salesBarnStallRepository.findByKey(stallId);
        this.spawnHorseInStall(stall);
    }

    @Override
    public void refreshStalls() {
        for (EntityHorse horse : this.spawnedSalesBarnStallCache.getAll()) {
            horse.m_142687_(Entity.RemovalReason.DISCARDED);
            this.spawnedSalesBarnStallCache.remove(horse);
        }
        for (SalesBarnStall stall : this.salesBarnStallRepository) {
            this.spawnHorseInStall(stall);
        }
        this.refreshChunkCache();
    }

    @Override
    public void refreshChunkCache() {
        EnumMap<ECLevel, Map<ChunkPos, List<SalesBarnStall>>> map = new EnumMap<ECLevel, Map<ChunkPos, List<SalesBarnStall>>>(ECLevel.class);
        for (SalesBarnStall stall : this.salesBarnStallRepository) {
            DirectionalCoordinate location = stall.getDirectionalCoordinate();
            ECLevel level = ECLevel.getByIdentifier(location.world());
            ChunkPos chunkPos = ChunkPosUtil.toChunkPos(location);
            Map stallChunkMap = map.computeIfAbsent(level, k -> new HashMap(1));
            List chunkList = stallChunkMap.computeIfAbsent(chunkPos, k -> new ArrayList(1));
            chunkList.add(stall);
        }
        this.salesBarnChunkCache.setMap(map);
    }

    @Override
    public void releaseStallLock(int stallId, ECPlayer player) {
        this.stallLockHandler.unlockStall(stallId, player);
    }
}

