/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.salesbarn;

import com.equestricraft.mod.client.horse.EntityHorse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;

public class SpawnedSalesBarnStallCache {
    private static final SpawnedSalesBarnStallCache instance = new SpawnedSalesBarnStallCache();
    private final Map<Integer, EntityHorse> stalls = new HashMap<Integer, EntityHorse>();
    private final StampedLock lock = new StampedLock();

    public static SpawnedSalesBarnStallCache getInstance() {
        return instance;
    }

    private SpawnedSalesBarnStallCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EntityHorse horse) {
        long stamp = this.lock.writeLock();
        try {
            this.stalls.put(horse.getInternalId(), horse);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityHorse get(int id) {
        long stamp = this.lock.readLock();
        try {
            EntityHorse entityHorse = this.stalls.get(id);
            return entityHorse;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EntityHorse> getAll() {
        long stamp = this.lock.readLock();
        try {
            List<EntityHorse> list = this.stalls.values().stream().toList();
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(EntityHorse horse) {
        long stamp = this.lock.writeLock();
        try {
            this.stalls.remove(horse.getInternalId());
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }
}

