/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.salesbarn;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.salesbarn.SalesBarnSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class StallLockHandler {
    private static final StallLockHandler instance = new StallLockHandler();
    private final Map<Integer, LockEntry> map = new HashMap<Integer, LockEntry>();

    public static StallLockHandler getInstance() {
        return instance;
    }

    private StallLockHandler() {
    }

    public synchronized Optional<Long> tryLockStallForPlayer(int stallId, ECPlayer player) {
        LockEntry lock = this.map.get(stallId);
        if (lock != null) {
            if (this.isLockActiveForPlayer(lock, player)) {
                return Optional.of(lock.expiry());
            }
            if (this.isLockActiveForDifferentPlayer(lock, player)) {
                return Optional.empty();
            }
        }
        long expiry = DateUtils.futureSecondsOffset(SalesBarnSettings.getStallLockSeconds()).getTime();
        LockEntry newLock = new LockEntry(player, expiry);
        this.map.put(stallId, newLock);
        return Optional.of(newLock.expiry());
    }

    public synchronized boolean isStallLockedForPlayer(int stallId, ECPlayer player) {
        LockEntry lock = this.map.get(stallId);
        return lock != null && this.isLockActiveForPlayer(lock, player);
    }

    private boolean isLockActiveForPlayer(LockEntry lock, ECPlayer player) {
        return lock.isActive() && lock.player().getId() == player.getId();
    }

    private boolean isLockActiveForDifferentPlayer(LockEntry lock, ECPlayer player) {
        return lock.isActive() && lock.player.getId() != player.getId();
    }

    public synchronized void unlockStall(int stallId, ECPlayer player) {
        LockEntry lock = this.map.get(stallId);
        if (lock != null && lock.player().getId() == player.getId()) {
            this.map.remove(stallId);
        }
    }

    private record LockEntry(ECPlayer player, long expiry) {
        boolean isActive() {
            return DateUtils.isInFuture(this.expiry);
        }
    }
}

