/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.scheduler;

import com.equestricraft.base.task.SchedulerTask;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.base.thread.ThreadChecker;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.Server;
import com.equestricraft.mod.scheduler.ModSchedulerTask;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ModTaskScheduler
extends TaskScheduler {
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(200);
    private static final Log log = Log.getLogger(ModTaskScheduler.class.getName());

    @Override
    public SchedulerTask runSyncTask(Runnable runnable2) {
        Server.getServer().execute(runnable2);
        return new ModSchedulerTask(CompletableFuture.completedFuture(null));
    }

    @Override
    public SchedulerTask runSyncTask(Runnable runnable2, Duration delay) {
        return this.runAsyncTask(() -> this.runSyncTask(runnable2), delay);
    }

    @Override
    public SchedulerTask runSyncTask(Runnable runnable2, Duration delay, Duration period) {
        return this.runAsyncTask(() -> this.runSyncTask(runnable2), delay, period);
    }

    @Override
    protected void awaitSyncTask(Runnable runnable2) {
        this.awaitSyncTask(() -> {
            runnable2.run();
            return null;
        });
    }

    @Override
    protected <T> T awaitSyncTask(Supplier<T> task) {
        if (ThreadChecker.isServerThread()) {
            return task.get();
        }
        CompletableFuture future = new CompletableFuture();
        Server.getServer().execute(() -> {
            Object t = task.get();
            future.complete(t);
        });
        try {
            return future.get();
        }
        catch (ExecutionException ex) {
            return null;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public SchedulerTask runAsyncTask(Runnable runnable2) {
        Future<?> future = this.scheduledExecutorService.submit(this.wrap(runnable2));
        return new ModSchedulerTask(future);
    }

    @Override
    public SchedulerTask runAsyncTask(Runnable runnable2, Duration delay) {
        ScheduledFuture<?> future = this.scheduledExecutorService.schedule(this.wrap(runnable2), delay.toMillis(), TimeUnit.MILLISECONDS);
        return new ModSchedulerTask(future);
    }

    @Override
    public SchedulerTask runAsyncTask(Runnable runnable2, Duration delay, Duration period) {
        ScheduledFuture<?> future = this.scheduledExecutorService.scheduleAtFixedRate(this.wrap(runnable2), delay.toMillis(), period.toMillis(), TimeUnit.MILLISECONDS);
        return new ModSchedulerTask(future);
    }

    private Runnable wrap(Runnable runnable2) {
        return () -> {
            try {
                runnable2.run();
            }
            catch (Exception ex) {
                log.error(String.format("Error executing task: %s", ex.getMessage()), ex);
            }
        };
    }
}

