/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.serverrules;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.core.serverrule.ServerRuleSession;
import com.equestricraft.mod.packet.ClientBoundServerRuleMenuPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.serverrules.ServerRuleService;
import java.util.List;

public class ServerRuleServiceImpl
implements ServerRuleService {
    @Service
    private ServerRuleSession serverRuleSession;

    @Override
    public Response showRules(OnlinePlayer player) {
        List<String> rules = this.serverRuleSession.retrieveServerRules();
        boolean hasAgreed = this.serverRuleSession.hasAgreedToRules(player);
        ClientBoundServerRuleMenuPacket packet = new ClientBoundServerRuleMenuPacket(rules, hasAgreed);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public Response agreeToRules(OnlinePlayer player) {
        ConfirmResponse response = player.getConfirmation().confirm(I18n.getLabel("server-rules.agree.confirm.title"), I18n.getLabel("server-rules.agree.confirm.message"));
        if (response.isYes()) {
            this.serverRuleSession.agreePlayerToServerRules(player);
            return ResponseFactory.success(I18n.getLabel("server-rules.agree.success"));
        }
        return ResponseFactory.fail(I18n.getLabel("server-rules.agree.fail"));
    }
}

