/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.shop;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.shop.ShopInfo;
import com.equestricraft.core.shop.ShopSession;
import com.equestricraft.mod.npc.NPCInteractEvent;
import com.equestricraft.mod.shop.ShopService;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class ShopListener {
    @Service
    private static ShopService shopService;
    @Service
    private static ShopSession shopSession;

    @SubscribeEvent
    public static void onNpcInteract(NPCInteractEvent event) {
        Optional<ShopInfo> shop = shopSession.retrieveInfoForNpcShop(event.getNpc().getId());
        shop.ifPresent(shopInfo -> event.addAction(I18n.getLabel("npc.action.shop"), () -> {
            Response response = shopService.showShopMenuForNpc(event.getOnlinePlayer(), (ShopInfo)shopInfo);
            event.getOnlinePlayer().showResponse(response);
        }));
    }

    private ShopListener() {
    }
}

