/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.shop;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.config.APIConfigDtoImpl;
import com.equestricraft.core.global.APIGlobalDtoImpl;
import com.equestricraft.core.item.ECItem;
import com.equestricraft.core.item.ECItemRepository;
import com.equestricraft.core.player.APIPlayerDtoImpl;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.shop.Shop;
import com.equestricraft.core.shop.ShopInfo;
import com.equestricraft.core.shop.ShopPurchaseResponse;
import com.equestricraft.core.shop.ShopRepository;
import com.equestricraft.core.shop.ShopSession;
import com.equestricraft.core.shop.item.ShopItem;
import com.equestricraft.core.shop.item.ShopItemInfo;
import com.equestricraft.core.shop.item.ShopItemRepository;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyRuleScriptExecutor;
import com.equestricraft.groovy.executor.RuleScriptResponse;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.packet.ClientBoundShopMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.NumberInputPrompt;
import com.equestricraft.mod.shop.ShopAccessException;
import com.equestricraft.mod.shop.ShopService;
import java.util.List;
import java.util.Optional;

public class ShopServiceImpl
implements ShopService {
    @Service
    private ShopSession shopSession;
    @Service
    private ShopItemRepository shopItemRepository;
    @Service
    private ShopRepository shopRepository;
    @Service
    private ECItemRepository ecItemRepository;
    private static final Log log = Log.getLogger(ShopServiceImpl.class.getName());

    @Override
    public Response showShopMenuForNpc(OnlinePlayer player, ShopInfo shopInfo) {
        Shop shop = (Shop)this.shopRepository.findByKey(shopInfo.id());
        try {
            this.ensurePlayerCanAccessShop(player, shop);
            this.showShopsMenuToPlayer(player, shopInfo);
            return ResponseFactory.success();
        }
        catch (ShopAccessException ex) {
            return ResponseFactory.fail(ex.getTitle(), ex.getMessage());
        }
    }

    private void ensurePlayerCanAccessShop(ECPlayer player, Shop shop) throws ShopAccessException {
        if (shop.getAccessScript().isBlank()) {
            return;
        }
        try {
            RuleScriptResponse result = ((GroovyRuleScriptExecutor)((GroovyRuleScriptExecutor)((GroovyRuleScriptExecutor)GroovyRuleScriptExecutor.start(shop.getAccessScript()).withPlayer(new APIPlayerDtoImpl(player.getCorePlayer()))).withGlobal(new APIGlobalDtoImpl())).withConfig(new APIConfigDtoImpl())).execute().result();
            if (Boolean.TRUE.equals(result.success())) {
                return;
            }
            throw new ShopAccessException(result.promptRequest().getMessage(), result.promptRequest().getTitle());
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing access script for shop %s", shop.getName()), ex);
            throw new ShopAccessException(ex.getMessage(), "Error");
        }
    }

    private void showShopsMenuToPlayer(ECPlayer player, ShopInfo shop) {
        List<ShopItemInfo> items = this.shopSession.retrieveShopItemsForShop(shop.id());
        ClientBoundShopMenuOpenPacket packet = new ClientBoundShopMenuOpenPacket(shop, items);
        player.sendPacket(packet);
    }

    @Override
    public Response purchaseItem(OnlinePlayer player, int itemId) {
        ShopItem item = (ShopItem)this.shopItemRepository.findByKey(itemId);
        ECItem ecItem = (ECItem)this.ecItemRepository.findByKey(item.getItemId());
        Optional<Number> quantity = NumberInputPrompt.showNumberInputPrompt(player, I18n.getLabel("shop.purchase.enter-quantity"), ecItem.getName());
        if (quantity.isPresent()) {
            ShopPurchaseResponse response = player.getShops().purchase(itemId, quantity.get().intValue());
            if (response.success()) {
                return ResponseFactory.success(I18n.getLabel("shop.purchase.success", response.purchasedItem().getName(), response.paymentValue()));
            }
            return ResponseFactory.fail(I18n.getLabel("shop.purchase.fail.title"), response.failMessage());
        }
        return ResponseFactory.fail();
    }
}

