/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.spawn;

import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.spawn.SpawnPoint;
import com.equestricraft.core.spawn.SpawnPointHolder;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.spawn.SpawnService;
import com.equestricraft.mod.util.BlockPosUtil;
import com.equestricraft.mod.util.ServerLevelUtil;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class SpawnServiceImpl
implements SpawnService {
    private final SpawnPointHolder spawnPointHolder = SpawnPointHolder.getInstance();
    private static final Log log = Log.getLogger(SpawnServiceImpl.class.getName());

    @Override
    public void sendPlayerToSpawn(OnlinePlayer player) {
        Optional<SpawnPoint> spawn = this.spawnPointHolder.getSpawnPoint();
        if (spawn.isPresent()) {
            player.getLocation().teleport(spawn.get().getLocation());
        } else {
            log.warn("Player {} could not be sent to the spawn point because no spawn point is active", (Object)player.getIgn());
        }
    }

    @Override
    public void setPlayersRespawnOnDeathLocation(OnlinePlayer player) {
        Optional<SpawnPoint> spawn = this.spawnPointHolder.getSpawnPoint();
        if (spawn.isPresent()) {
            ServerPlayer serverPlayer = player.serverPlayer();
            DirectionalCoordinate location = spawn.get().getLocation();
            ResourceKey<Level> world = ServerLevelUtil.getWorldsResourceKey(location.world());
            serverPlayer.m_9158_(world, BlockPosUtil.toBlockPos(location), location.rotationY(), true, false);
        }
    }
}

