/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.speed;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.mod.command.Arg;
import com.equestricraft.mod.command.Command;
import com.equestricraft.mod.command.Permission;
import com.equestricraft.mod.context.ModPlayerContext;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Abilities;

@Command(value="speed")
@Permission(value="equestricraft.player.speed")
public class SpeedCommand {
    private static final Map<UUID, Float> defaultSpeeds = new HashMap<UUID, Float>();
    private static final float DEFAULT_SPEED = 0.05f;

    @Command
    public Response onCommand(@Arg double speed) {
        float speedValue = (float)(speed * (double)0.05f);
        ServerPlayer player = ModPlayerContext.getServerPlayer();
        Abilities abilities = player.m_150110_();
        defaultSpeeds.putIfAbsent(player.m_142081_(), Float.valueOf(abilities.m_35942_()));
        abilities.m_35943_(speedValue);
        player.f_8906_.m_141995_((Packet)new ClientboundPlayerAbilitiesPacket(abilities));
        return ResponseFactory.success("Speed set to " + speed);
    }

    @Command(value="reset")
    public Response onReset() {
        ServerPlayer player = ModPlayerContext.getServerPlayer();
        float defaultSpeed = defaultSpeeds.getOrDefault(player.m_142081_(), Float.valueOf(0.05f)).floatValue();
        Abilities abilities = player.m_150110_();
        abilities.m_35943_(defaultSpeed);
        player.f_8906_.m_141995_((Packet)new ClientboundPlayerAbilitiesPacket(abilities));
        return ResponseFactory.success("Speed reset to default 1");
    }
}

