/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.staffchat;

import com.equestricraft.core.player.ECPlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.StampedLock;

public class StaffChatMembers {
    private static final StaffChatMembers instance = new StaffChatMembers();
    private final List<Integer> playerIds = new ArrayList<Integer>(0);
    private final StampedLock lock = new StampedLock();

    public static StaffChatMembers getInstance() {
        return instance;
    }

    private StaffChatMembers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayerToChat(ECPlayer player) {
        long stamp = this.lock.writeLock();
        try {
            this.playerIds.add(player.getId());
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlayerInStaffChat(ECPlayer player) {
        long stamp = this.lock.readLock();
        try {
            boolean bl = this.playerIds.contains(player.getId());
            return bl;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getPlayerIdsInChat() {
        long stamp = this.lock.readLock();
        try {
            List<Integer> list = Collections.unmodifiableList(this.playerIds);
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayerFromChat(ECPlayer player) {
        long stamp = this.lock.writeLock();
        try {
            this.playerIds.removeIf(id -> id.intValue() == player.getId());
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }
}

