/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.staffchat;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.staffchat.StaffChatMembers;
import com.equestricraft.mod.staffchat.StaffChatService;
import java.util.List;

public class StaffChatServiceImpl
implements StaffChatService {
    private final StaffChatMembers staffChatMembers = StaffChatMembers.getInstance();
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();

    @Override
    public Response toggleStaffChat(OnlinePlayer player) {
        if (this.staffChatMembers.isPlayerInStaffChat(player)) {
            this.staffChatMembers.removePlayerFromChat(player);
            return ResponseFactory.success(I18n.getLabel("staff-chat.disabled.message"));
        }
        this.staffChatMembers.addPlayerToChat(player);
        return ResponseFactory.success(I18n.getLabel("staff-chat.enabled.message"));
    }

    @Override
    public Response sendMessageInStaffChat(OnlinePlayer player, String message) {
        String formattedMessage = I18n.getLabel("staff-chat.message", player.getIgn(), message);
        List<ECPlayer> members = this.onlinePlayerCache.getAllPlayers().stream().filter(p -> p.getPermission().hasPermission("equestricraft.staff.chat")).toList();
        members.forEach(m -> m.sendMessage(formattedMessage));
        return ResponseFactory.success();
    }

    @Override
    public boolean processChatMessage(OnlinePlayer player, String message) {
        if (!this.staffChatMembers.isPlayerInStaffChat(player)) {
            return false;
        }
        this.sendMessageInStaffChat(player, message);
        return true;
    }
}

