/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.tablist;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.club.Club;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.core.rank.Rank;
import com.equestricraft.core.utilities.TabListHelper;
import com.equestricraft.mod.tablist.TabListSession;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TabListSessionImpl
implements TabListSession {
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();

    @Override
    public void updateTabListForPlayer(ECPlayer player) {
        String top = this.buildTop(player);
        String bottom = this.buildBottom(player);
        TabListHelper.updateTabListForPlayer(player, top, bottom);
    }

    private String buildTop(ECPlayer player) {
        LinkedList<String> lines = new LinkedList<String>();
        lines.add(I18n.getLabel("tab-list.title"));
        lines.add(I18n.getLabel("tab-list.display-name", player.getDisplayName()));
        int count = this.onlinePlayerCache.getOnlinePlayerCount();
        lines.add(I18n.getLabel("tab-list.online-player", count));
        Optional<String> address = player.getDiscoverLocations().getCurrentLocation().getAddressString();
        address.ifPresent(a -> lines.add(I18n.getLabel("tab-list.location", a)));
        lines.add(I18n.getLabel("tab-list.separator.top"));
        return TabListSessionImpl.toText(lines);
    }

    private String buildBottom(ECPlayer player) {
        LinkedList<String> lines = new LinkedList<String>();
        lines.add(I18n.getLabel("tab-list.separator.bottom"));
        Rank rank = player.getProgression().getRank();
        lines.add(I18n.getLabel("tab-list.rank", rank.getName()));
        Optional<Job> jobOptional = player.getJob().getCurrent();
        jobOptional.ifPresent(job -> lines.add(I18n.getLabel("tab-list.job", job.getName())));
        Optional<Club> clubOptional = player.getClub().getClub();
        if (clubOptional.isPresent()) {
            Club club = clubOptional.get();
            lines.add(I18n.getLabel("tab-list.club", club.getChatTag()));
            lines.add(I18n.getLabel("tab-list.club-rank", player.getClub().getRankLabel()));
        }
        return TabListSessionImpl.toText(lines);
    }

    private static String toText(List<String> lines) {
        return lines.stream().map(l -> l.concat("&r")).collect(Collectors.joining("\n"));
    }
}

