/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.tablist;

import com.equestricraft.cdi.Services;
import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.tablist.TabListSession;
import com.equestricraft.mod.tablist.TabListSettings;
import java.util.Timer;
import java.util.TimerTask;

public class TabListUpdater {
    private static final TabListUpdater instance = new TabListUpdater();
    private final TabListSession tabListSession = Services.getService(TabListSession.class);
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();
    private final Timer timer = new Timer(ThreadUtils.threadName("tab-list-updater"));
    private boolean started = false;
    private static final Log log = Log.getLogger(TabListUpdater.class.getName());

    public static void start() {
        instance.startUpdater();
    }

    private TabListUpdater() {
    }

    private synchronized void startUpdater() {
        if (this.started) {
            throw new IllegalStateException("Tab list updater has already been started");
        }
        long interval = (long)TabListSettings.getRefreshIntervalSeconds().intValue() * 1000L;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    TabListUpdater.this.updateTabListForOnlinePlayers();
                }
                catch (Exception ex) {
                    log.error(String.format("Error on tab list update: %s", ex.getMessage()), ex);
                }
            }
        }, interval, interval);
        this.started = true;
    }

    private void updateTabListForOnlinePlayers() {
        for (ECPlayer player : this.onlinePlayerCache.getAllPlayers()) {
            this.tabListSession.updateTabListForPlayer(player);
        }
    }
}

