/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.teleport;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.teleport.TeleportService;
import com.equestricraft.mod.teleport.TpoRequest;
import com.equestricraft.mod.teleport.TpoRequestCache;
import java.util.Date;
import java.util.Optional;

public class TeleportServiceImpl
implements TeleportService {
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();
    private final TpoRequestCache tpoRequestCache = TpoRequestCache.getInstance();

    @Override
    public Response teleportToPlayer(OnlinePlayer player, String toIgn) {
        OnlinePlayer targetPlayer = this.onlinePlayerCache.requirePlayer(toIgn).require(OnlinePlayer.class);
        if (player.equals(targetPlayer)) {
            return ResponseFactory.fail(I18n.getLabel("tpo.cannot-tp-to-yourself"));
        }
        if (player.hasPermission("equestricraft.tpo.bypass")) {
            player.getLocation().teleport(targetPlayer.getDirectionalCoordinate());
            return ResponseFactory.success(I18n.getLabel("tpo.teleport.success", targetPlayer.getIgn()));
        }
        TpoRequest request = new TpoRequest(player, targetPlayer, new Date());
        this.tpoRequestCache.addRequest(request);
        targetPlayer.sendMessage(I18n.getLabel("tpo.new-request", player.getIgn()));
        return ResponseFactory.success(I18n.getLabel("tpo.waiting-for-accept", targetPlayer.getIgn()));
    }

    @Override
    public Response acceptTpoRequest(OnlinePlayer player) {
        Optional<TpoRequest> oldestRequest = this.tpoRequestCache.findOldestRequestForPlayer(player.getId());
        if (oldestRequest.isPresent()) {
            TpoRequest request = oldestRequest.get();
            player.getLocation().teleport(request.targetPlayer().getDirectionalCoordinate());
            oldestRequest.get().sourcePlayer().sendMessage(I18n.getLabel("tpo.player-accepted-request", request.targetPlayer().getIgn()));
            return ResponseFactory.success(I18n.getLabel("tpo.request-accepted", request.sourcePlayer().getIgn()));
        }
        return ResponseFactory.fail(I18n.getLabel("tpo.no-requests"));
    }

    @Override
    public Response rejectTpoRequest(OnlinePlayer player) {
        Optional<TpoRequest> oldestRequest = this.tpoRequestCache.findOldestRequestForPlayer(player.getId());
        if (oldestRequest.isPresent()) {
            TpoRequest request = oldestRequest.get();
            this.tpoRequestCache.removeRequest(request);
            request.sourcePlayer().sendMessage(I18n.getLabel("tpo.player-denied-request", request.targetPlayer().getIgn()));
            return ResponseFactory.success(I18n.getLabel("tpo.request-denied", request.sourcePlayer().getIgn()));
        }
        return ResponseFactory.fail(I18n.getLabel("tpo.no-requests"));
    }
}

