/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.teleport;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.mod.teleport.TeleportSettings;
import com.equestricraft.mod.teleport.TpoRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Predicate;

public class TpoRequestCache {
    private static final TpoRequestCache instance = new TpoRequestCache();
    private final List<TpoRequest> requests = new ArrayList<TpoRequest>();
    private final StampedLock lock = new StampedLock();

    public static TpoRequestCache getInstance() {
        return instance;
    }

    private TpoRequestCache() {
        this.startRequestClearOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(TpoRequest request) {
        long stamp = this.lock.writeLock();
        try {
            this.requests.add(request);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TpoRequest> findOldestRequestForPlayer(int playerId) {
        long stamp = this.lock.readLock();
        try {
            Optional<TpoRequest> optional = this.requests.stream().filter(r -> r.targetPlayer().getId() == playerId).filter(Predicate.not(this::hasRequestExpired)).min(Comparator.comparing(TpoRequest::time));
            return optional;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(TpoRequest request) {
        long stamp = this.lock.writeLock();
        try {
            this.requests.remove(request);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private void startRequestClearOut() {
        long millis = (long)TeleportSettings.getTpoRequestTimeoutSeconds().intValue() * 1000L;
        new Timer(ThreadUtils.threadName("tpo-request-clear-out")).schedule(new TimerTask(){

            @Override
            public void run() {
                TpoRequestCache.this.clearOutOldRequests();
            }
        }, millis, millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOutOldRequests() {
        long stamp = this.lock.writeLock();
        try {
            List<TpoRequest> toRemove = this.requests.stream().filter(this::hasRequestExpired).toList();
            this.requests.removeAll(toRemove);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private boolean hasRequestExpired(TpoRequest request) {
        return DateUtils.secondsSince(request.time()) > TeleportSettings.getTpoRequestTimeoutSeconds();
    }
}

