/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.title;

import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.title.TitleService;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerPlayer;

public class TitleServiceImpl
implements TitleService {
    private static final int DEFAULT_FADE_IN_TIME = 10;
    private static final int DEFAULT_DISPLAY_TIME = 70;
    private static final int DEFAULT_FADE_OUT_TIME = 10;

    @Override
    public void showTitleToPlayer(ECPlayer player, String title, String subtitle) {
        this.showTitleToPlayer(player, title, subtitle, 10, 70, 10);
    }

    @Override
    public void showTitleToPlayer(ECPlayer player, String title, String subtitle, int fadeInTicks, int displayTicks, int fadeOutTicks) {
        Objects.requireNonNull(title, "Must supply a title");
        ServerPlayer serverPlayer = player.require(OnlinePlayer.class).serverPlayer();
        serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetTitleTextPacket((Component)new TextComponent(title)));
        if (subtitle != null && !subtitle.isBlank()) {
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetSubtitleTextPacket((Component)new TextComponent(subtitle)));
        }
        serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetTitlesAnimationPacket(fadeInTicks, displayTicks, fadeOutTicks));
    }

    @Override
    public void showActionBarToPlayer(ECPlayer player, String text) {
        Objects.requireNonNull(text, "Must supply text");
        ServerPlayer serverPlayer = player.require(OnlinePlayer.class).serverPlayer();
        serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)new TextComponent(text)));
    }
}

