/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.university;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Service;
import com.equestricraft.mod.command.Arg;
import com.equestricraft.mod.command.Async;
import com.equestricraft.mod.command.Command;
import com.equestricraft.mod.command.argproviders.OnlinePlayersArgumentSuggestionProvider;
import com.equestricraft.mod.context.ModPlayerContext;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.university.UniversityCommandService;

@Command(value="university")
public class UniversityCommand {
    @Service
    private UniversityCommandService universityCommandService;

    @Async
    @Command(value="exam")
    public Response onExam(@Arg(name="moduleId") int moduleId) {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.universityCommandService.startExam(player, moduleId);
    }

    @Async
    @Command(value="degrees")
    public Response onDegrees() {
        return this.universityCommandService.showDegrees(ModPlayerContext.getOnlinePlayer());
    }

    @Async
    @Command(value="award-degree")
    public Response onAwardDegree(@Arg(name="degreeId") int degreeId) {
        return this.universityCommandService.awardDegree(ModPlayerContext.getOnlinePlayer(), degreeId);
    }

    @Async
    @Command(value="award-house-points")
    public Response onAwardHousePoints(@Arg(name="player", suggestionProvider=OnlinePlayersArgumentSuggestionProvider.class) String ign, @Arg(name="points") int points) {
        return this.universityCommandService.awardHousePoints(ign, points);
    }

    @Async
    @Command(value="my-house-points")
    public Response onMyHousePoints() {
        return this.universityCommandService.myHousePoints(ModPlayerContext.getOnlinePlayer());
    }

    @Async
    @Command(value="current-season")
    public Response onCurrentSeason() {
        return this.universityCommandService.currentSeason();
    }

    @Async
    @Command(value="appoint-advisor")
    public Response appointAdvisor(@Arg(name="player", suggestionProvider=OnlinePlayersArgumentSuggestionProvider.class) String ign, @Arg(name="house") int houseId) {
        return this.universityCommandService.appointHouseAdvisor(ign, houseId);
    }

    @Async
    @Command(value="remove-advisor")
    public Response removeAdvisor(@Arg(name="player", suggestionProvider=OnlinePlayersArgumentSuggestionProvider.class) String ign, @Arg(name="house") int houseId) {
        return this.universityCommandService.removeHouseAdvisor(ign, houseId);
    }

    @Async
    @Command(value="my-house-advisors")
    public Response myHouseAdvisors() {
        return this.universityCommandService.myHouseAdvisors(ModPlayerContext.getOnlinePlayer());
    }
}

