/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.university;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerService;
import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.core.player.university.degree.PlayerDegreeInfoDto;
import com.equestricraft.core.university.NotInHouseException;
import com.equestricraft.core.university.UniversityExamDto;
import com.equestricraft.core.university.UniversityService;
import com.equestricraft.core.university.UniversitySession;
import com.equestricraft.core.university.house.UniversityHouse;
import com.equestricraft.core.university.house.advisor.UniversityHouseAdvisorInfo;
import com.equestricraft.core.university.house.advisor.UniversityHouseAdvisorSession;
import com.equestricraft.core.university.house.point.HousePointInfo;
import com.equestricraft.core.university.house.point.UniversityHousePointSession;
import com.equestricraft.core.university.house.season.UniversityHouseSeason;
import com.equestricraft.core.university.house.season.UniversityHouseSeasonInfo;
import com.equestricraft.core.university.house.season.UniversityHouseSeasonRepository;
import com.equestricraft.core.university.house.season.UniversitySeasonSession;
import com.equestricraft.mod.packet.ClientBoundPlayerDegreeInfoListPacket;
import com.equestricraft.mod.packet.ClientBoundUniversityExamPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.university.UniversityCommandService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UniversityCommandServiceImpl
implements UniversityCommandService {
    @Service
    private UniversityService universityService;
    @Service
    private UniversityHouseAdvisorSession universityHouseAdvisorSession;
    @Service
    private UniversitySession universitySession;
    @Service
    private UniversityHouseSeasonRepository universityHouseSeasonRepository;
    @Service
    private UniversitySeasonSession universitySeasonSession;
    @Service
    private UniversityHousePointSession universityHousePointSession;
    @Service
    private PlayerService playerService;

    @Override
    public Response startExam(OnlinePlayer player, int moduleId) {
        if (!this.universitySession.canPlayerAffordToResit(player, moduleId)) {
            return ResponseFactory.fail(I18n.getLabel("university.cannot-afford-resit"));
        }
        ConfirmResponse confirm = player.getConfirmation().confirm(I18n.getLabel("university.exam.start.title"), I18n.getLabel("university.exam.start.confirm"));
        if (confirm.isYes()) {
            UniversityExamDto exam = this.universityService.getExam(moduleId);
            this.openExamMenu(player, exam);
            return ResponseFactory.success();
        }
        return ResponseFactory.fail();
    }

    private void openExamMenu(OnlinePlayer onlinePlayer, UniversityExamDto exam) {
        ClientBoundUniversityExamPacket clientBoundPacket = new ClientBoundUniversityExamPacket(exam);
        onlinePlayer.sendPacket(clientBoundPacket);
    }

    @Override
    public Response showDegrees(OnlinePlayer player) {
        List<PlayerDegreeInfoDto> degrees = player.getUniversity().getDegrees();
        ClientBoundPlayerDegreeInfoListPacket packet = new ClientBoundPlayerDegreeInfoListPacket(degrees);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public Response awardDegree(OnlinePlayer player, int degreeId) {
        return this.universityService.awardDegree(player, degreeId);
    }

    @Override
    public Response awardHousePoints(String ign, int points) {
        CorePlayer p = this.playerService.retrievePlayerByIgn(ign);
        return this.universityService.awardPointsToPlayersHouse(p, points);
    }

    @Override
    public Response myHousePoints(OnlinePlayer player) {
        return this.universityService.getPlayersCurrentHousePoints(player).map(points -> ResponseFactory.success(I18n.getLabel("university.my-house-points", points))).orElseGet(() -> ResponseFactory.fail(I18n.getLabel("university.not-in-house")));
    }

    @Override
    public Response currentSeason() {
        UniversityHouseSeasonInfo currentSeasonInfo = this.getCurrentSeasonInfo();
        Stream.Builder<String> builder = Stream.builder();
        builder.accept(I18n.getLabel("university.current-season.name", currentSeasonInfo.name()));
        if (currentSeasonInfo.daysLeft() != null) {
            builder.accept(I18n.getLabel("university.current-season.days-left", currentSeasonInfo.daysLeft()));
        }
        if (currentSeasonInfo.leadingHouseName() != null) {
            builder.accept(I18n.getLabel("university.current-season.leader", currentSeasonInfo.leadingHouseName(), currentSeasonInfo.leadingHousePoints()));
        }
        String details = builder.build().collect(Collectors.joining("\n"));
        return ResponseFactory.success(details);
    }

    private UniversityHouseSeasonInfo getCurrentSeasonInfo() {
        UniversityHouseSeason currentSeason = this.universityHouseSeasonRepository.getCurrentSeason();
        Optional<Date> nextSeasonStartDate = this.universitySeasonSession.getNextSeasonStartDate();
        Integer daysUntilEnd = nextSeasonStartDate.map(DateUtils::daysUntil).orElse(null);
        HousePointInfo leadingHouse = this.universityHousePointSession.getLeadingHouse().orElse(null);
        return this.buildHouseSeasonInfo(currentSeason, daysUntilEnd, leadingHouse);
    }

    private UniversityHouseSeasonInfo buildHouseSeasonInfo(UniversityHouseSeason currentSeason, Integer daysUntilEnd, HousePointInfo houseInfo) {
        return new UniversityHouseSeasonInfo(currentSeason.getName(), daysUntilEnd, houseInfo != null ? houseInfo.house().getName() : null, houseInfo != null ? houseInfo.points() : 0);
    }

    @Override
    public Response appointHouseAdvisor(String ign, int houseId) {
        CorePlayer player = this.playerService.retrievePlayerByIgn(ign);
        this.universityHouseAdvisorSession.appointPlayerAsAdvisor(player, houseId);
        return ResponseFactory.success();
    }

    @Override
    public Response removeHouseAdvisor(String ign, int houseId) {
        CorePlayer player = this.playerService.retrievePlayerByIgn(ign);
        this.universityHouseAdvisorSession.removePlayerAsAdvisor(player, houseId);
        return ResponseFactory.success();
    }

    @Override
    public Response myHouseAdvisors(OnlinePlayer player) {
        List<String> advisors = this.getAdvisorsForPlayersHouse(player);
        String text = String.join((CharSequence)", ", advisors);
        return ResponseFactory.success(text);
    }

    private List<String> getAdvisorsForPlayersHouse(ECPlayer player) {
        return player.getUniversity().getHouse().map(this::getHouseAdvisorNames).orElseThrow(NotInHouseException::new);
    }

    private List<String> getHouseAdvisorNames(UniversityHouse h) {
        return this.universityHouseAdvisorSession.retrieveAdvisorsForHouse(h.getId()).stream().map(UniversityHouseAdvisorInfo::playerIgn).toList();
    }
}

