/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.university;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.university.UniversityExamDto;
import com.equestricraft.mod.client.gui.university.UniversityExamQuestionScreen;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundUniversityExamResultPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class UniversityExamHandler {
    private final UniversityExamDto exam;
    private Integer lastShownQuestion = null;
    private int countCorrect = 0;
    private int countIncorrect = 0;

    public static void startExam(UniversityExamDto universityExamDto) {
        UniversityExamHandler handler = new UniversityExamHandler(universityExamDto);
        handler.nextQuestion();
    }

    private UniversityExamHandler(UniversityExamDto exam) {
        this.exam = exam;
    }

    public void questionAnswered(boolean correct) {
        if (correct) {
            ++this.countCorrect;
        } else {
            ++this.countIncorrect;
        }
        if (!this.nextQuestion()) {
            ServerBoundUniversityExamResultPacket packet = new ServerBoundUniversityExamResultPacket(this.exam.moduleId(), this.countCorrect, this.countIncorrect);
            Network.sendToServer(packet);
            Minecraft.m_91087_().f_91074_.m_6352_((Component)new TextComponent(I18n.getLabel("university.exam-finished")), Minecraft.m_91087_().f_91074_.m_142081_());
        }
    }

    private boolean nextQuestion() {
        int nextQuestion;
        int n = nextQuestion = this.lastShownQuestion == null ? 0 : this.lastShownQuestion + 1;
        if (nextQuestion >= this.exam.questions().size()) {
            return false;
        }
        UniversityExamQuestionScreen.showExamQuestionScreen("Question " + (nextQuestion + 1), this, this.exam.questions().get(nextQuestion));
        this.lastShownQuestion = nextQuestion;
        return true;
    }
}

