/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.util;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public enum AnimUtil {
    JUMP(0.2f, 0.4f, 0.1f);

    private final float easeIn;
    private final float easeOut;
    private final float startOffset;

    private AnimUtil(float easeIn, float easeOut, float startOffset) {
        this.startOffset = startOffset;
        this.easeOut = easeOut;
        this.easeIn = easeIn;
    }

    public static float remap(float value, float origLow, float origHigh, float newLow, float newHigh) {
        return newLow + (value - origLow) * (newHigh - newLow) / (origHigh - origLow);
    }

    public float bezierLerpInOut(float value, float max) {
        float fit01 = AnimUtil.remap(Mth.m_14036_((float)(value - this.startOffset), (float)0.0f, (float)(max - this.startOffset)), 0.0f, max - this.startOffset, 0.0f, 1.0f);
        if (fit01 == 0.0f || fit01 == 1.0f && this.easeOut != 0.0f) {
            return 0.0f;
        }
        if (fit01 < this.easeIn) {
            float calc = AnimUtil.remap(fit01, 0.0f, this.easeIn, 0.0f, 1.0f);
            Vec2 p1 = new Vec2(0.0f, calc);
            Vec2 p2 = new Vec2(calc, 1.0f);
            Vec2 result = p1.m_165910_(p2.m_165910_(p1.m_165903_(-1.0f)).m_165903_(calc));
            return result.f_82471_;
        }
        if (fit01 > 1.0f - this.easeOut) {
            float calc = AnimUtil.remap(1.0f - fit01, 0.0f, this.easeOut, 0.0f, 1.0f);
            Vec2 p1 = new Vec2(0.0f, calc);
            Vec2 p2 = new Vec2(calc, 1.0f);
            Vec2 result = p1.m_165910_(p2.m_165910_(p1.m_165903_(-1.0f)).m_165903_(calc));
            return result.f_82471_;
        }
        return 1.0f;
    }

    public float getStartOffset() {
        return this.startOffset;
    }
}

