/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.util;

import com.equestricraft.common.ECLevel;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.mod.util.ServerLevelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class BlockPosUtil {
    public static BlockPos toBlockPos(DirectionalCoordinate directionalCoordinate) {
        return new BlockPos(directionalCoordinate.x(), directionalCoordinate.y(), directionalCoordinate.z());
    }

    public static DirectionalCoordinate toDirectionalCoordinate(BlockPos blockPos, Level level, float yRot, float xRot) {
        return BlockPosUtil.toDirectionalCoordinate(blockPos, ServerLevelUtil.getECLevel(level), yRot, xRot);
    }

    public static DirectionalCoordinate toDirectionalCoordinate(BlockPos blockPos, ECLevel level, float yRot, float xRot) {
        return new DirectionalCoordinate(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), level.getIdentifier(), yRot, xRot);
    }

    public static BlockPos toBlockPos(Coordinate coordinate) {
        return new BlockPos(coordinate.x(), coordinate.y(), coordinate.z());
    }

    public static Coordinate toCoordinate(BlockPos blockPos, Level level) {
        return BlockPosUtil.toCoordinate(blockPos, ServerLevelUtil.getECLevel(level));
    }

    public static Coordinate toCoordinate(BlockPos blockPos, ECLevel level) {
        return new Coordinate(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), level.name());
    }

    public static BlockPos toBlockPos(BlockCoordinate blockCoordinate) {
        return new BlockPos(blockCoordinate.x(), blockCoordinate.y(), blockCoordinate.z());
    }

    public static BlockCoordinate toBlockCoordinate(BlockPos blockPos, Level level) {
        return BlockPosUtil.toBlockCoordinate(blockPos, ServerLevelUtil.getECLevel(level));
    }

    public static BlockCoordinate toBlockCoordinate(BlockPos blockPos, ECLevel level) {
        return new BlockCoordinate(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), level.getIdentifier());
    }

    private BlockPosUtil() {
    }
}

