/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.util;

import com.equestricraft.base.text.TextItem;
import com.equestricraft.common.util.StringUtils;
import com.equestricraft.mod.util.ChatFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class ComponentUtil {
    public static TextComponent buildColoredTextComponent(String text) {
        return new TextComponent(ChatFormat.formattingCodes(text));
    }

    public static TextComponent buildComponentFromTextItem(TextItem item) {
        Style style;
        TextComponent component;
        TextComponent textComponent = component = item.getText() != null ? ComponentUtil.buildColoredTextComponent(item.getText()) : new TextComponent(StringUtils.emptyString());
        if (item.getColor() != null) {
            style = component.m_7383_().m_178520_(item.getColor().getIntValue());
            component.m_6270_(style);
        }
        if (item.isBold()) {
            component.m_130940_(ChatFormatting.BOLD);
        }
        if (item.isItalic()) {
            component.m_130940_(ChatFormatting.ITALIC);
        }
        if (item.isUnderline()) {
            component.m_130940_(ChatFormatting.UNDERLINE);
        }
        if (item.isStrikethrough()) {
            component.m_130940_(ChatFormatting.STRIKETHROUGH);
        }
        if (item.getHoverItem() != null) {
            style = component.m_7383_().m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)ComponentUtil.buildComponentFromTextItem(item.getHoverItem())));
            component.m_6270_(style);
        }
        for (TextItem childItem : item.getChildItems()) {
            component.m_7220_((Component)ComponentUtil.buildComponentFromTextItem(childItem));
        }
        return component;
    }

    private ComponentUtil() {
    }
}

