/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.util;

import com.equestricraft.common.ECLevel;
import com.equestricraft.mod.ModDimensions;
import com.equestricraft.mod.Server;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ServerLevelUtil {
    public static String getEntitiesServerLevelIdentifier(Entity entity) {
        return entity.m_20193_().m_46472_().m_135782_().m_135815_();
    }

    public static ServerLevel getEntitiesServerLevel(Entity entity) {
        String identifier = ServerLevelUtil.getEntitiesServerLevelIdentifier(entity);
        return ServerLevelUtil.getServerLevel(identifier);
    }

    public static ECLevel getEntitiesECLevel(Entity entity) {
        String identifier = ServerLevelUtil.getEntitiesServerLevelIdentifier(entity);
        return ECLevel.getByIdentifier(identifier);
    }

    public static ECLevel getECLevel(Level level) {
        String identifier = level.m_46472_().m_135782_().m_135815_();
        return ECLevel.getByIdentifier(identifier);
    }

    public static String getLevelIdentifier(Level level) {
        return ServerLevelUtil.getECLevel(level).getIdentifier();
    }

    public static ServerLevel getServerLevel(String name) {
        return Server.getServer().m_129880_(ServerLevelUtil.getWorldsResourceKey(name));
    }

    public static ResourceKey<Level> getWorldsResourceKey(String world) {
        return switch (ECLevel.getByIdentifier(world)) {
            default -> throw new IncompatibleClassChangeError();
            case ECLevel.OVERWORLD -> Level.f_46428_;
            case ECLevel.NETHER -> Level.f_46429_;
            case ECLevel.END -> Level.f_46430_;
            case ECLevel.EXPLORE -> ModDimensions.EC_EXPLORE_DIM_KEY;
            case ECLevel.PLOT_GRID -> ModDimensions.EC_PLOT_GRID_DIM_KEY;
            case ECLevel.PLOT_NATURAL -> ModDimensions.EC_PLOT_NATURAL_DIM_KEY;
        };
    }

    public static ServerLevel[] getServerLevels() {
        return new ServerLevel[]{ServerLevelUtil.getOverworld(), ServerLevelUtil.getNether(), ServerLevelUtil.getEnd(), ServerLevelUtil.getExplore(), ServerLevelUtil.getPlotGrid(), ServerLevelUtil.getPlotNatural()};
    }

    public static ServerLevel getOverworld() {
        return ServerLevelUtil.getServerLevel(ECLevel.OVERWORLD.getIdentifier());
    }

    public static ServerLevel getNether() {
        return ServerLevelUtil.getServerLevel(ECLevel.NETHER.getIdentifier());
    }

    public static ServerLevel getEnd() {
        return ServerLevelUtil.getServerLevel(ECLevel.END.getIdentifier());
    }

    public static ServerLevel getExplore() {
        return ServerLevelUtil.getServerLevel(ECLevel.EXPLORE.getIdentifier());
    }

    public static ServerLevel getPlotGrid() {
        return ServerLevelUtil.getServerLevel(ECLevel.PLOT_GRID.getIdentifier());
    }

    public static ServerLevel getPlotNatural() {
        return ServerLevelUtil.getServerLevel(ECLevel.PLOT_NATURAL.getIdentifier());
    }

    private ServerLevelUtil() {
    }
}

