/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.util;

import com.equestricraft.base.text.TextItem;
import com.equestricraft.common.Argb;
import net.minecraft.network.FriendlyByteBuf;

public class TextItemUtil {
    public static void encode(FriendlyByteBuf buffer, TextItem textItem) {
        if (textItem.getText() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(textItem.getText());
        } else {
            buffer.writeBoolean(false);
        }
        if (textItem.getColor() != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(textItem.getColor().getIntValue());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeBoolean(textItem.isBold());
        buffer.writeBoolean(textItem.isItalic());
        buffer.writeBoolean(textItem.isUnderline());
        buffer.writeBoolean(textItem.isStrikethrough());
        if (textItem.getHoverItem() != null) {
            buffer.writeBoolean(true);
            TextItemUtil.encode(buffer, textItem.getHoverItem());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeInt(textItem.getChildItems().size());
        for (TextItem child : textItem.getChildItems()) {
            TextItemUtil.encode(buffer, child);
        }
    }

    public static TextItem decode(FriendlyByteBuf buffer) {
        String text = buffer.readBoolean() ? buffer.m_130277_() : null;
        TextItem item = new TextItem(text);
        if (buffer.readBoolean()) {
            Argb color = Argb.fromIntValue(buffer.readInt());
            item.setColor(color);
        }
        boolean bold = buffer.readBoolean();
        item.setBold(bold);
        boolean italic = buffer.readBoolean();
        item.setItalic(italic);
        boolean underline = buffer.readBoolean();
        item.setUnderline(underline);
        boolean strikethrough = buffer.readBoolean();
        item.setStrikethrough(strikethrough);
        if (buffer.readBoolean()) {
            TextItem hoverItem = TextItemUtil.decode(buffer);
            item.setHoverItem(hoverItem);
        }
        int childItemCount = buffer.readInt();
        for (int i = 0; i < childItemCount; ++i) {
            TextItem childItem = TextItemUtil.decode(buffer);
            item.addChildItem(childItem);
        }
        return item;
    }

    private TextItemUtil() {
    }
}

