/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.version;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.version.BuildInformation;
import com.equestricraft.mod.version.VersionCommandService;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VersionCommandServiceImpl
implements VersionCommandService {
    @Override
    public Response getVersionInfo() {
        BuildInformation version = BuildInformation.get();
        Stream.Builder<String> builder = Stream.builder();
        builder.accept(I18n.getLabel("version.number", version.getVersionString()));
        if (version.isDevBuild()) {
            builder.accept(I18n.getLabel("version.dev-build"));
        }
        if (version.isDebugChatOutput()) {
            builder.accept(I18n.getLabel("version.debug-chat-output"));
        }
        String versionString = builder.build().collect(Collectors.joining("\n"));
        return ResponseFactory.success(versionString);
    }
}

